/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.events;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import moe.paring.createlogisticsbackport.CreateLogisticsBackportClient;
import moe.paring.createlogisticsbackport.content.equipment.blueprint.BlueprintOverlayRenderer2;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorConnectionHandler;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorInteractionHandler;
import moe.paring.createlogisticsbackport.content.kinetics.chainConveyor.ChainConveyorRidingHandler;
import moe.paring.createlogisticsbackport.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import moe.paring.createlogisticsbackport.content.logistics.packagerLink.LogisticallyLinkedClientHandler;
import moe.paring.createlogisticsbackport.content.logistics.tableCloth.TableClothOverlayRenderer;
import moe.paring.createlogisticsbackport.foundation.utility.TickBasedCache;
import moe.paring.createlogisticsbackport.polyfill.behaviour.filtering.FilteringRenderer2;
import moe.paring.createlogisticsbackport.polyfill.misc.LogisticsHatArmorLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!Backend.isGameActive()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        BlueprintOverlayRenderer2.tick();
        ChainConveyorInteractionHandler.clientTick();
        ChainConveyorRidingHandler.clientTick();
        ChainConveyorConnectionHandler.clientTick();
        PackagePortTargetSelectionHandler.tick();
        LogisticallyLinkedClientHandler.tick();
        TableClothOverlayRenderer.tick();
        FactoryPanelConnectionHandler.clientTick();
        TickBasedCache.clientTick();
        FilteringRenderer2.tick();
        CreateLogisticsBackportClient.VALUE_SETTINGS_HANDLER.tick();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        ChainConveyorInteractionHandler.drawCustomBlockSelection(ms, (MultiBufferSource)buffer, camera);
        buffer.draw();
        RenderSystem.enableCull();
        ms.m_85849_();
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void addEntityRenderLayers(EntityRenderersEvent.AddLayers event) {
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            LogisticsHatArmorLayer.registerOnAll(dispatcher);
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "blueprint", BlueprintOverlayRenderer2.OVERLAY);
        }
    }
}

