/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.foundation.block.connected;

import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moe.paring.createlogisticsbackport.foundation.block.connected.CTSpriteShiftEntry2;
import moe.paring.createlogisticsbackport.foundation.block.connected.CTType2;
import moe.paring.createlogisticsbackport.foundation.block.connected.ConnectedTextureBehaviour2;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class CTModel2
extends BakedModelWrapperWithData {
    private static final ModelProperty<CTData> CT_PROPERTY = new ModelProperty();
    private final ConnectedTextureBehaviour2 behaviour;

    public CTModel2(BakedModel originalModel, ConnectedTextureBehaviour2 behaviour) {
        super(originalModel);
        this.behaviour = behaviour;
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        return builder.with(CT_PROPERTY, (Object)this.createCTData(world, pos, state));
    }

    protected CTData createCTData(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        CTData data = new CTData();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            CTType2 dataType;
            CopycatBlock ufb;
            Block block;
            BlockState actualState = world.m_8055_(pos);
            if (!this.behaviour.buildContextForOccludedDirections() && !Block.m_152444_((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)mutablePos.m_122159_((Vec3i)pos, face)) && (!((block = actualState.m_60734_()) instanceof CopycatBlock) || (ufb = (CopycatBlock)block).canFaceBeOccluded(actualState, face)) || (dataType = this.behaviour.getDataType(world, pos, state, face)) == null) continue;
            ConnectedTextureBehaviour2.CTContext context = this.behaviour.buildContext(world, pos, state, face, dataType.getContextRequirement());
            data.put(face, dataType.getTextureIndex(context));
        }
        return data;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        if (!extraData.has(CT_PROPERTY)) {
            return quads;
        }
        CTData data = (CTData)extraData.get(CT_PROPERTY);
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            CTSpriteShiftEntry2 spriteShift;
            BakedQuad quad = (BakedQuad)quads.get(i);
            int index = data.get(quad.m_111306_());
            if (index == -1 || (spriteShift = this.behaviour.getShift(state, rand, quad.m_111306_(), quad.m_173410_())) == null || quad.m_173410_() != spriteShift.getOriginal()) continue;
            BakedQuad newQuad = BakedQuadHelper.clone((BakedQuad)quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU((int[])vertexData, (int)vertex);
                float v = BakedQuadHelper.getV((int[])vertexData, (int)vertex);
                BakedQuadHelper.setU((int[])vertexData, (int)vertex, (float)spriteShift.getTargetU(u, index));
                BakedQuadHelper.setV((int[])vertexData, (int)vertex, (float)spriteShift.getTargetV(v, index));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }

    private static class CTData {
        private final int[] indices = new int[6];

        public CTData() {
            Arrays.fill(this.indices, -1);
        }

        public void put(Direction face, int texture) {
            this.indices[face.m_122411_()] = texture;
        }

        public int get(Direction face) {
            return this.indices[face.m_122411_()];
        }
    }
}

