/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.mixin;

import com.simibubi.create.compat.computercraft.implementation.ComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.peripheral.IPeripheral;
import moe.paring.createlogisticsbackport.compat.computercraft.peripherals.FrogportPeripheral;
import moe.paring.createlogisticsbackport.compat.computercraft.peripherals.PackagerPeripheral;
import moe.paring.createlogisticsbackport.compat.computercraft.peripherals.PostboxPeripheral;
import moe.paring.createlogisticsbackport.compat.computercraft.peripherals.RedstoneRequesterPeripheral;
import moe.paring.createlogisticsbackport.compat.computercraft.peripherals.RepackagerPeripheral;
import moe.paring.createlogisticsbackport.compat.computercraft.peripherals.StockTickerPeripheral;
import moe.paring.createlogisticsbackport.compat.computercraft.peripherals.TableClothShopPeripheral;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.frogport.FrogportBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packagePort.postbox.PostboxBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packager.PackagerBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.packager.repackager.RepackagerBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.StockTickerBlockEntity;
import moe.paring.createlogisticsbackport.content.logistics.tableCloth.TableClothBlockEntity;
import net.minecraftforge.common.util.NonNullSupplier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ComputerBehaviour.class})
public class ComputerBehaviourMixin {
    @Inject(method={"getPeripheralFor"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void getPeripheralFor(SmartBlockEntity be, CallbackInfoReturnable<NonNullSupplier<IPeripheral>> cir) {
        if (be instanceof FrogportBlockEntity) {
            FrogportBlockEntity fpbe = (FrogportBlockEntity)be;
            cir.setReturnValue(() -> new FrogportPeripheral(fpbe));
            return;
        }
        if (be instanceof PostboxBlockEntity) {
            PostboxBlockEntity pbbe = (PostboxBlockEntity)be;
            cir.setReturnValue(() -> new PostboxPeripheral(pbbe));
            return;
        }
        if (be instanceof StockTickerBlockEntity) {
            StockTickerBlockEntity sgbe = (StockTickerBlockEntity)be;
            cir.setReturnValue(() -> new StockTickerPeripheral(sgbe));
            return;
        }
        if (be instanceof RepackagerBlockEntity) {
            RepackagerBlockEntity rpbe = (RepackagerBlockEntity)be;
            cir.setReturnValue(() -> new RepackagerPeripheral(rpbe));
            return;
        }
        if (be instanceof PackagerBlockEntity) {
            PackagerBlockEntity pgbe = (PackagerBlockEntity)be;
            cir.setReturnValue(() -> new PackagerPeripheral(pgbe));
            return;
        }
        if (be instanceof RedstoneRequesterBlockEntity) {
            RedstoneRequesterBlockEntity rrbe = (RedstoneRequesterBlockEntity)be;
            cir.setReturnValue(() -> new RedstoneRequesterPeripheral(rrbe));
            return;
        }
        if (be instanceof TableClothBlockEntity) {
            TableClothBlockEntity tcbe = (TableClothBlockEntity)be;
            cir.setReturnValue(() -> new TableClothShopPeripheral(tcbe));
        }
    }
}

