/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.polyfill.behaviour;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ValueBoxTransform2 {
    protected float scale = this.getScale();

    public abstract Vec3 getLocalOffset(LevelAccessor var1, BlockPos var2, BlockState var3);

    public abstract void rotate(LevelAccessor var1, BlockPos var2, BlockState var3, PoseStack var4);

    public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
        Vec3 offset = this.getLocalOffset(level, pos, state);
        if (offset == null) {
            return false;
        }
        return localHit.m_82554_(offset) < (double)(this.scale / 2.0f);
    }

    public void transform(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
        Vec3 position = this.getLocalOffset(level, pos, state);
        if (position == null) {
            return;
        }
        ms.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.rotate(level, pos, state, ms);
        ms.m_85841_(this.scale, this.scale, this.scale);
    }

    public boolean shouldRender(LevelAccessor level, BlockPos pos, BlockState state) {
        return !state.m_60795_() && this.getLocalOffset(level, pos, state) != null;
    }

    public int getOverrideColor() {
        return -1;
    }

    protected Vec3 rotateHorizontally(BlockState state, Vec3 vec) {
        float yRot = 0.0f;
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            yRot = AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            yRot = AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        return VecHelper.rotateCentered((Vec3)vec, (double)yRot, (Direction.Axis)Direction.Axis.Y);
    }

    public float getScale() {
        return 0.5f;
    }

    public float getFontScale() {
        return 0.015625f;
    }

    public static abstract class Sided
    extends ValueBoxTransform2 {
        protected Direction direction = Direction.UP;

        public Sided fromSide(Direction direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Vec3 location = this.getSouthLocation();
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.verticalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.X);
            return location;
        }

        protected abstract Vec3 getSouthLocation();

        @Override
        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            float yRot = AngleHelper.horizontalAngle((Direction)this.getSide()) + 180.0f;
            float xRot = this.getSide() == Direction.UP ? 90.0f : (this.getSide() == Direction.DOWN ? 270.0f : 0.0f);
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)yRot)).rotateX((double)xRot);
        }

        @Override
        public boolean shouldRender(LevelAccessor level, BlockPos pos, BlockState state) {
            return super.shouldRender(level, pos, state) && this.isSideActive(state, this.getSide());
        }

        @Override
        public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
            return this.isSideActive(state, this.getSide()) && super.testHit(level, pos, state, localHit);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return true;
        }

        public Direction getSide() {
            return this.direction;
        }
    }

    public static abstract class Dual
    extends ValueBoxTransform {
        protected boolean first;

        public Dual(boolean first) {
            this.first = first;
        }

        public boolean isFirst() {
            return this.first;
        }

        public static Pair<ValueBoxTransform, ValueBoxTransform> makeSlots(Function<Boolean, ? extends ValueBoxTransform.Dual> factory) {
            return Pair.of((Object)((ValueBoxTransform)factory.apply(true)), (Object)((ValueBoxTransform)factory.apply(false)));
        }

        public boolean testHit(BlockState state, Vec3 localHit) {
            Vec3 offset = this.getLocalOffset(state);
            if (offset == null) {
                return false;
            }
            return localHit.m_82554_(offset) < (double)(this.scale / 3.5f);
        }
    }
}

