/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.polyfill.behaviour;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.RaycastHelper;
import moe.paring.createlogisticsbackport.CreateLogisticsBackportClient;
import moe.paring.createlogisticsbackport.polyfill.behaviour.ValueBoxTransform2;
import moe.paring.createlogisticsbackport.polyfill.behaviour.ValueSettingsBehaviour2;
import moe.paring.createlogisticsbackport.polyfill.behaviour.filtering.SidedFilteringBehaviour2;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ValueSettingsInputHandler2 {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (!ValueSettingsInputHandler2.canInteract(player)) {
            return;
        }
        if (AllBlocks.CLIPBOARD.isIn(player.m_21205_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)blockEntity;
        if (event.getSide() == LogicalSide.CLIENT) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateLogisticsBackportClient.VALUE_SETTINGS_HANDLER.cancelIfWarmupAlreadyStarted(event));
        }
        if (event.isCanceled()) {
            return;
        }
        for (BlockEntityBehaviour behaviour : sbe.getAllBehaviours()) {
            ValueSettingsBehaviour2 valueSettingsBehaviour;
            if (!(behaviour instanceof ValueSettingsBehaviour2) || (valueSettingsBehaviour = (ValueSettingsBehaviour2)behaviour).bypassesInput(player.m_21205_()) || !valueSettingsBehaviour.mayInteract(player)) continue;
            BlockHitResult ray = RaycastHelper.rayTraceRange((Level)world, (Player)player, (double)10.0);
            if (ray == null) {
                return;
            }
            if (behaviour instanceof SidedFilteringBehaviour2 && (behaviour = ((SidedFilteringBehaviour2)behaviour).get(ray.m_82434_())) == null || !valueSettingsBehaviour.isActive() || valueSettingsBehaviour.onlyVisibleWithWrench() && !AllTags.AllItemTags.WRENCH.matches(player.m_21120_(hand))) continue;
            ValueBoxTransform2 valueBoxTransform2 = valueSettingsBehaviour.getSlotPositioning();
            if (valueBoxTransform2 instanceof ValueBoxTransform2.Sided) {
                ValueBoxTransform2.Sided sidedSlot = (ValueBoxTransform2.Sided)valueBoxTransform2;
                if (!sidedSlot.isSideActive(sbe.m_58900_(), ray.m_82434_())) continue;
                sidedSlot.fromSide(ray.m_82434_());
            }
            boolean fakePlayer = player instanceof FakePlayer;
            if (!valueSettingsBehaviour.testHit(ray.m_82450_()) && !fakePlayer) continue;
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            if (!valueSettingsBehaviour.acceptsValueSettings() || fakePlayer) {
                valueSettingsBehaviour.onShortInteract(player, hand, ray.m_82434_(), ray);
                return;
            }
            if (event.getSide() == LogicalSide.CLIENT) {
                BehaviourType type = behaviour.getType();
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateLogisticsBackportClient.VALUE_SETTINGS_HANDLER.startInteractionWith(pos, type, hand, ray.m_82434_()));
            }
            return;
        }
    }

    public static boolean canInteract(Player player) {
        return player != null && !player.m_5833_() && !player.m_6144_();
    }
}

