/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.polyfill.behaviour;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import javax.annotation.Nullable;
import moe.paring.createlogisticsbackport.polyfill.behaviour.ValueSettingsBehaviour2;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

public class ValueSettingsPacket2
extends BlockEntityConfigurationPacket<SmartBlockEntity> {
    private int row;
    private int value;
    private InteractionHand interactHand;
    private Direction side;
    private boolean ctrlDown;
    private int behaviourIndex;
    private BlockHitResult hitResult;

    public ValueSettingsPacket2(BlockPos pos, int row, int value, @Nullable InteractionHand interactHand, @Nullable BlockHitResult hitResult, Direction side, boolean ctrlDown, int behaviourIndex) {
        super(pos);
        this.row = row;
        this.value = value;
        this.interactHand = interactHand;
        this.hitResult = hitResult;
        this.side = side;
        this.ctrlDown = ctrlDown;
        this.behaviourIndex = behaviourIndex;
    }

    public ValueSettingsPacket2(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.value);
        buffer.m_130130_(this.row);
        buffer.writeBoolean(this.interactHand != null);
        if (this.interactHand != null) {
            buffer.writeBoolean(this.interactHand == InteractionHand.MAIN_HAND);
            buffer.m_130062_(this.hitResult);
        }
        buffer.m_130130_(this.side.ordinal());
        buffer.writeBoolean(this.ctrlDown);
        buffer.m_130130_(this.behaviourIndex);
    }

    protected void readSettings(FriendlyByteBuf buffer) {
        this.value = buffer.m_130242_();
        this.row = buffer.m_130242_();
        if (buffer.readBoolean()) {
            this.interactHand = buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            this.hitResult = buffer.m_130283_();
        }
        this.side = Direction.values()[buffer.m_130242_()];
        this.ctrlDown = buffer.readBoolean();
        this.behaviourIndex = buffer.m_130242_();
    }

    protected void applySettings(ServerPlayer player, SmartBlockEntity be) {
        for (BlockEntityBehaviour behaviour : be.getAllBehaviours()) {
            ValueSettingsBehaviour2 valueSettingsBehaviour;
            if (!(behaviour instanceof ValueSettingsBehaviour2) || !(valueSettingsBehaviour = (ValueSettingsBehaviour2)behaviour).acceptsValueSettings() || this.behaviourIndex != valueSettingsBehaviour.netId()) continue;
            if (this.interactHand != null) {
                valueSettingsBehaviour.onShortInteract((Player)player, this.interactHand, this.side, this.hitResult);
                return;
            }
            valueSettingsBehaviour.setValueSettings((Player)player, new ValueSettingsBehaviour2.ValueSettings2(this.row, this.value), this.ctrlDown);
            return;
        }
    }

    protected void applySettings(SmartBlockEntity be) {
    }
}

