/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.polyfill.behaviour.filtering;

import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import moe.paring.createlogisticsbackport.polyfill.behaviour.ValueBoxTransform2;
import moe.paring.createlogisticsbackport.polyfill.behaviour.filtering.FilteringBehaviour2;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SidedFilteringBehaviour2
extends FilteringBehaviour2 {
    Map<Direction, FilteringBehaviour2> sidedFilters;
    private BiFunction<Direction, FilteringBehaviour2, FilteringBehaviour2> filterFactory;
    private Predicate<Direction> validDirections;

    public SidedFilteringBehaviour2(SmartBlockEntity be, ValueBoxTransform2.Sided sidedSlot, BiFunction<Direction, FilteringBehaviour2, FilteringBehaviour2> filterFactory, Predicate<Direction> validDirections) {
        super(be, sidedSlot);
        this.filterFactory = filterFactory;
        this.validDirections = validDirections;
        this.sidedFilters = new IdentityHashMap<Direction, FilteringBehaviour2>();
        this.updateFilterPresence();
    }

    public void initialize() {
        super.initialize();
    }

    public FilteringBehaviour2 get(Direction side) {
        return this.sidedFilters.get(side);
    }

    public void updateFilterPresence() {
        HashSet<Direction> valid = new HashSet<Direction>();
        for (Direction d : Iterate.directions) {
            if (!this.validDirections.test(d)) continue;
            valid.add(d);
        }
        for (Direction d : Iterate.directions) {
            if (valid.contains(d)) {
                if (this.sidedFilters.containsKey(d)) continue;
                this.sidedFilters.put(d, this.filterFactory.apply(d, new FilteringBehaviour2(this.blockEntity, this.slotPositioning)));
                continue;
            }
            if (!this.sidedFilters.containsKey(d)) continue;
            this.removeFilter(d);
        }
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("Filters", (Tag)NBTHelper.writeCompoundList(this.sidedFilters.entrySet(), entry -> {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("Side", ((Direction)entry.getKey()).m_122411_());
            ((FilteringBehaviour2)entry.getValue()).write(compound, clientPacket);
            return compound;
        }));
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        NBTHelper.iterateCompoundList((ListTag)nbt.m_128437_("Filters", 10), compound -> {
            Direction face = Direction.m_122376_((int)compound.m_128451_("Side"));
            if (this.sidedFilters.containsKey(face)) {
                this.sidedFilters.get(face).read((CompoundTag)compound, clientPacket);
            }
        });
        super.read(nbt, clientPacket);
    }

    public void tick() {
        super.tick();
        this.sidedFilters.values().forEach(BlockEntityBehaviour::tick);
    }

    @Override
    public boolean setFilter(Direction side, ItemStack stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        this.sidedFilters.get(side).setFilter(stack);
        return true;
    }

    @Override
    public ItemStack getFilter(Direction side) {
        if (!this.sidedFilters.containsKey(side)) {
            return ItemStack.f_41583_;
        }
        return this.sidedFilters.get(side).getFilter();
    }

    public boolean test(Direction side, ItemStack stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        return this.sidedFilters.get(side).test(stack);
    }

    @Override
    public void destroy() {
        this.sidedFilters.values().forEach(FilteringBehaviour2::destroy);
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return this.sidedFilters.values().stream().reduce(ItemRequirement.NONE, (a, b) -> a.union(b.getRequiredItems()), (a, b) -> a.union(b));
    }

    public void removeFilter(Direction side) {
        if (!this.sidedFilters.containsKey(side)) {
            return;
        }
        this.sidedFilters.remove(side).destroy();
    }

    public boolean testHit(LevelAccessor level, BlockPos pos, Direction direction, Vec3 hit) {
        ValueBoxTransform2.Sided sidedPositioning = (ValueBoxTransform2.Sided)this.slotPositioning;
        BlockState state = this.blockEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.blockEntity.m_58899_()));
        return sidedPositioning.fromSide(direction).testHit(level, pos, state, localHit);
    }
}

