/*
 * Decompiled with CFR 0.152.
 */
package moe.paring.createlogisticsbackport.polyfill.misc;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfo;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfoReloadListener;
import com.simibubi.create.foundation.mixin.accessor.AgeableListModelAccessor;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import moe.paring.createlogisticsbackport.content.logistics.stockTicker.StockTickerBlock;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LogisticsHatArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public LogisticsHatArmorLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    @Nullable
    public static PartialModel getHatFor(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        ItemStack headItem = entity.m_6844_(EquipmentSlot.HEAD);
        if (!headItem.m_41619_()) {
            return null;
        }
        int stations = 0;
        Level level = entity.m_9236_();
        BlockPos pos = entity.m_20183_();
        PartialModel hat = null;
        for (Direction d : Iterate.horizontalDirections) {
            for (int y : Iterate.zeroAndOne) {
                StockTickerBlock lw;
                PartialModel hatOfStation;
                Block block = level.m_8055_(pos.m_121945_(d).m_6630_(y)).m_60734_();
                if (!(block instanceof StockTickerBlock) || (hatOfStation = (lw = (StockTickerBlock)block).getHat((LevelAccessor)level, pos, entity)) == null) continue;
                hat = hatOfStation;
                ++stations;
            }
        }
        if (stations == 1) {
            return hat;
        }
        return null;
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        PartialModel hat = LogisticsHatArmorLayer.getHatFor(entity);
        if (hat == null) {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        ms.m_85836_();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        TrainHatInfo info = TrainHatInfoReloadListener.getHatInfoFor((EntityType)entity.m_6095_());
        ArrayList partsToHead = new ArrayList();
        if (entityModel instanceof AgeableListModel) {
            ModelPart head;
            AgeableListModel model = (AgeableListModel)entityModel;
            if (model.f_102610_) {
                if (model.f_102007_) {
                    float f = 1.5f / model.f_102010_;
                    ms.m_85841_(f, f, f);
                }
                ms.m_85837_(0.0, (double)(model.f_170338_ / 16.0f), (double)(model.f_170339_ / 16.0f));
            }
            if ((head = LogisticsHatArmorLayer.getHeadPart(model)) != null) {
                partsToHead.addAll(TrainHatInfo.getAdjustedPart((TrainHatInfo)info, (ModelPart)head, (String)""));
            }
        } else if (entityModel instanceof HierarchicalModel) {
            HierarchicalModel model = (HierarchicalModel)entityModel;
            partsToHead.addAll(TrainHatInfo.getAdjustedPart((TrainHatInfo)info, (ModelPart)model.m_142109_(), (String)"head"));
        }
        if (!partsToHead.isEmpty()) {
            partsToHead.forEach(part -> part.m_104299_(ms));
            ModelPart lastChild = (ModelPart)partsToHead.get(partsToHead.size() - 1);
            if (!lastChild.m_171326_()) {
                ModelPart.Cube cube = (ModelPart.Cube)lastChild.f_104212_.get(Mth.m_14045_((int)info.cubeIndex(), (int)0, (int)(lastChild.f_104212_.size() - 1)));
                ms.m_85837_(info.offset().m_7096_() / 16.0, ((double)(cube.f_104336_ - cube.f_104339_) + info.offset().m_7098_()) / 16.0, info.offset().m_7094_() / 16.0);
                float max = Math.max(cube.f_104338_ - cube.f_104335_, cube.f_104340_ - cube.f_104337_) / 8.0f * info.scale();
                ms.m_85841_(max, max, max);
            }
            ms.m_85841_(1.0f, -1.0f, -1.0f);
            ms.m_252880_(0.0f, -0.140625f, 0.0f);
            msr.rotateX(-8.5);
            BlockState air = Blocks.f_50016_.m_49966_();
            CachedBufferer.partial((PartialModel)hat, (BlockState)air).forEntityRender().light(light).renderInto(ms, buffer.m_6299_(Sheets.m_110790_()));
        }
        ms.m_85849_();
    }

    public static void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            LogisticsHatArmorLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.f_114362_.values()) {
            LogisticsHatArmorLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        EntityModel model = livingRenderer.m_7200_();
        if (!(model instanceof HierarchicalModel) && !(model instanceof AgeableListModel)) {
            return;
        }
        LogisticsHatArmorLayer layer = new LogisticsHatArmorLayer(livingRenderer);
        livingRenderer.m_115326_(layer);
    }

    private static ModelPart getHeadPart(AgeableListModel<?> model) {
        Iterator iterator = ((AgeableListModelAccessor)model).create$callHeadParts().iterator();
        if (iterator.hasNext()) {
            ModelPart part = (ModelPart)iterator.next();
            return part;
        }
        iterator = ((AgeableListModelAccessor)model).create$callBodyParts().iterator();
        if (iterator.hasNext()) {
            ModelPart part = (ModelPart)iterator.next();
            return part;
        }
        return null;
    }
}

