/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GMCConfig {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue GENERATE_MELTING_CASTING_RECIPES;
    public static ForgeConfigSpec.BooleanValue GENERATE_EXTRUDER_RECIPES;
    public static ForgeConfigSpec.BooleanValue GENERATE_FLUID_SOLIDIFICATION_RECIPES;
    public static ForgeConfigSpec.ConfigValue<List<String>> IGNORED_GT_MATERIALS;
    public static ForgeConfigSpec.BooleanValue GENERATE_PLATE_SHIELD;
    public static ForgeConfigSpec.DoubleValue GLOBAL_HEAD_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_HEAD_MINING_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_HEAD_ATTACK_DAMAGE_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_LIMB_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_LIMB_DRAW_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_LIMB_VELOCITY_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_LIMB_ACCURACY_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_GRIP_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_GRIP_ACCURACY_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_GRIP_MELEE_DAMAGE_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_HANDLE_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_HANDLE_MINING_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_HANDLE_ATTACK_DAMAGE_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_HANDLE_ATTACK_SPEED_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_ARMOR_DURABILITY_MODIFIER;
    public static ForgeConfigSpec.DoubleValue GLOBAL_SHIELD_DURABILITY_MODIFIER;

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("Configuration related to material recipe generation").push("Recipe Integration").worldRestart();
        GENERATE_MELTING_CASTING_RECIPES = COMMON_BUILDER.define("generateMeltingAndCastingRecipes", false);
        GENERATE_EXTRUDER_RECIPES = COMMON_BUILDER.define("generateExtruderRecipes", true);
        GENERATE_FLUID_SOLIDIFICATION_RECIPES = COMMON_BUILDER.define("generateFluidSolidificationRecipes", false);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Configuration related to material modification.").push("Material Modification");
        IGNORED_GT_MATERIALS = COMMON_BUILDER.comment("Disable generating tinker's material information for the following GT materials.").define("ignoredGTMaterials", (Object)Lists.newArrayList((Object[])new String[]{"bronze", "cobalt", "copper", "diamond", "flint", "invar", "iron", "netherite", "polybenzimidazole", "polyethylene", "polytetrafluoroethylene", "rose_gold", "rubber", "steel", "silicone_rubber", "styrene_butadiene_rubber", "wood"}));
        GENERATE_PLATE_SHIELD = COMMON_BUILDER.comment("Generate plate shields for GT materials.").define("generatePlateShield", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Configuration related to global modifiers.").push("Global Modifiers");
        COMMON_BUILDER.comment("Configuration related to head global modifiers").push("Head Global Modifiers");
        GLOBAL_HEAD_DURABILITY_MODIFIER = COMMON_BUILDER.defineInRange("globalHeadDurabilityModifier", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
        GLOBAL_HEAD_MINING_SPEED_MODIFIER = COMMON_BUILDER.defineInRange("globalHeadMiningSpeedModifier", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
        GLOBAL_HEAD_ATTACK_DAMAGE_MODIFIER = COMMON_BUILDER.defineInRange("globalHeadAttackDamageModifier", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Configuration related to limb global modifiers").push("Limb Global Modifiers");
        GLOBAL_LIMB_DURABILITY_MODIFIER = COMMON_BUILDER.defineInRange("globalLimbDurabilityModifier", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
        GLOBAL_LIMB_DRAW_SPEED_MODIFIER = COMMON_BUILDER.defineInRange("globalLimbDrawSpeedModifier", 0.001, Double.MIN_VALUE, Double.MAX_VALUE);
        GLOBAL_LIMB_VELOCITY_MODIFIER = COMMON_BUILDER.defineInRange("globalLimbVelocityModifier", -8.0E-4, Double.MIN_VALUE, Double.MAX_VALUE);
        GLOBAL_LIMB_ACCURACY_MODIFIER = COMMON_BUILDER.defineInRange("globalLimbAccuracyModifier", -5.0E-4, Double.MIN_VALUE, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Configuration related to grip global modifiers").push("Grip Global Modifiers");
        GLOBAL_GRIP_DURABILITY_MODIFIER = COMMON_BUILDER.defineInRange("globalGripDurabilityModifier", 0.2, Double.MIN_VALUE, Double.MAX_VALUE);
        GLOBAL_GRIP_ACCURACY_MODIFIER = COMMON_BUILDER.defineInRange("globalGripAccuracyModifier", 0.16, Double.MIN_VALUE, Double.MAX_VALUE);
        GLOBAL_GRIP_MELEE_DAMAGE_MODIFIER = COMMON_BUILDER.defineInRange("globalMeleeDamageModifier", 1.5, Double.MIN_VALUE, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Configuration related to handle global modifiers").push("Handle Global Modifiers");
        GLOBAL_HANDLE_DURABILITY_MODIFIER = COMMON_BUILDER.defineInRange("globalHandleDurabilityModifier", 1.0, 0.1, Double.MAX_VALUE);
        GLOBAL_HANDLE_MINING_SPEED_MODIFIER = COMMON_BUILDER.defineInRange("globalHandleMiningSpeedModifier", 1.0, 0.1, Double.MAX_VALUE);
        GLOBAL_HANDLE_ATTACK_DAMAGE_MODIFIER = COMMON_BUILDER.defineInRange("globalHandleAttackDamageModifier", 1.0, 0.1, Double.MAX_VALUE);
        GLOBAL_HANDLE_ATTACK_SPEED_MODIFIER = COMMON_BUILDER.defineInRange("globalHandleAttackSpeedModifier", 1.0, 0.1, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Configuration related to armor global modifiers").push("Armor Global Modifiers");
        GLOBAL_ARMOR_DURABILITY_MODIFIER = COMMON_BUILDER.defineInRange("globalArmorDurabilityModifier", 0.15, 0.1, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Configuration related to shield global modifiers").push("Shield Global Modifiers");
        GLOBAL_SHIELD_DURABILITY_MODIFIER = COMMON_BUILDER.defineInRange("globalShieldDurabilityModifier", 1.0, 0.1, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

