/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.data;

import com.gregtechceu.gtceu.common.data.GTMaterials;
import java.util.Locale;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;

public enum GMCByproduct implements IByproduct
{
    COPPER(false, GTMaterials.Copper.getFluid()),
    IRON(false, GTMaterials.Iron.getFluid()),
    GOLD(false, GTMaterials.Gold.getFluid()),
    SMALL_GOLD("gold", false, GTMaterials.Gold.getFluid(), 48, IMeltingContainer.OreRateType.METAL),
    COBALT(false, GTMaterials.Cobalt.getFluid()),
    STEEL(false, GTMaterials.Steel.getFluid()),
    DEBRIS("netherite_scrap", false, TinkerFluids.moltenDebris.get(), 144, IMeltingContainer.OreRateType.METAL),
    TIN(false, GTMaterials.Tin.getFluid()),
    SILVER(false, GTMaterials.Silver.getFluid()),
    NICKEL(false, GTMaterials.Nickel.getFluid()),
    LEAD(false, GTMaterials.Lead.getFluid()),
    PLATINUM(false, GTMaterials.Platinum.getFluid());

    private final String name;
    private final boolean alwaysPresent;
    private final Fluid fluid;
    private final int amount;
    private final IMeltingContainer.OreRateType oreRate;

    private GMCByproduct(boolean alwaysPresent, Fluid fluid, int amount, IMeltingContainer.OreRateType oreRate) {
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.alwaysPresent = alwaysPresent;
        this.fluid = fluid;
        this.amount = amount;
        this.oreRate = oreRate;
    }

    private GMCByproduct(boolean alwaysPresent, Fluid fluid) {
        this(alwaysPresent, fluid, 144, IMeltingContainer.OreRateType.METAL);
    }

    public FluidOutput getFluid(float scale) {
        return FluidOutput.fromFluid((Fluid)this.fluid, (int)((int)((float)this.amount * scale)));
    }

    private GMCByproduct(String name, boolean alwaysPresent, Fluid fluid, int amount, IMeltingContainer.OreRateType oreRate) {
        this.name = name;
        this.alwaysPresent = alwaysPresent;
        this.fluid = fluid;
        this.amount = amount;
        this.oreRate = oreRate;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAlwaysPresent() {
        return this.alwaysPresent;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getAmount() {
        return this.amount;
    }

    public IMeltingContainer.OreRateType getOreRate() {
        return this.oreRate;
    }
}

