/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.data;

import com.google.common.collect.Sets;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.data.pack.GTDynamicPackContents;
import com.mojang.datafixers.util.Pair;
import dev.electrolyte.gm_construct.GMConstruct;
import dev.electrolyte.gm_construct.data.FluidTooltipGeneration;
import dev.electrolyte.gm_construct.data.MaterialDataGeneration;
import dev.electrolyte.gm_construct.data.MaterialStatsGeneration;
import dev.electrolyte.gm_construct.data.MaterialTraitsGeneration;
import dev.electrolyte.gm_construct.helper.GTMaterialHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;

@ParametersAreNonnullByDefault
public class GMCDynamicDataPack
implements PackResources {
    private static final ObjectSet<String> SERVER_DOMAINS = new ObjectOpenHashSet();
    private static final GTDynamicPackContents DATA = new GTDynamicPackContents();
    private String name;

    public GMCDynamicDataPack(String name) {
        this.name = name;
    }

    public static void clearData() {
        DATA.clearData();
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... pElements) {
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType pPackType, ResourceLocation pLocation) {
        if (pPackType == PackType.SERVER_DATA) {
            return DATA.getResource(pLocation);
        }
        return null;
    }

    public static void generateAllMaterialData() {
        for (Material material : GTMaterialHelper.REGISTERED_TOOL_MATERIALS) {
            Pair<ResourceLocation, byte[]> data = MaterialDataGeneration.INSTANCE.generateMaterialData(GMConstruct.materialId(material.getName()), material);
            DATA.addToData((ResourceLocation)data.getFirst(), (byte[])data.getSecond());
            data = MaterialStatsGeneration.INSTANCE.generateMaterialStats(material);
            DATA.addToData((ResourceLocation)data.getFirst(), (byte[])data.getSecond());
            data = MaterialTraitsGeneration.INSTANCE.generateMaterialTraits(material);
            DATA.addToData((ResourceLocation)data.getFirst(), (byte[])data.getSecond());
        }
        Pair<ResourceLocation, byte[]> data = FluidTooltipGeneration.INSTANCE.generateMaterialFluidTooltips();
        DATA.addToData((ResourceLocation)data.getFirst(), (byte[])data.getSecond());
    }

    public void m_8031_(PackType pPackType, String pNamespace, String pPath, PackResources.ResourceOutput pResourceOutput) {
        if (pPackType == PackType.SERVER_DATA) {
            DATA.listResources(pNamespace, pPath, pResourceOutput);
        }
    }

    public Set<String> m_5698_(PackType pType) {
        return pType == PackType.SERVER_DATA ? SERVER_DOMAINS : Set.of();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> pDeserializer) {
        if (pDeserializer == PackMetadataSection.f_243696_) {
            return (T)new PackMetadataSection((Component)Component.m_237113_((String)"GMConstruct Dynamic Data"), SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
        }
        return null;
    }

    public String m_5542_() {
        return this.name;
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
    }

    static {
        SERVER_DOMAINS.addAll((Collection)Sets.newHashSet((Object[])new String[]{"gm_construct", "minecraft", "forge", "c"}));
    }
}

