/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.data.pack.GTDynamicPackContents;
import com.mojang.datafixers.util.Pair;
import dev.electrolyte.gm_construct.GMConstruct;
import dev.electrolyte.gm_construct.data.LangGeneration;
import dev.electrolyte.gm_construct.data.MaterialRenderInfoGeneration;
import dev.electrolyte.gm_construct.helper.GTMaterialHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GMCDynamicResourcePack
implements PackResources {
    private static final ObjectSet<String> CLIENT_DOMAINS = new ObjectOpenHashSet();
    private static final GTDynamicPackContents DATA = new GTDynamicPackContents();
    private final String name;

    public GMCDynamicResourcePack(String name) {
        this.name = name;
    }

    public static void clearData() {
        DATA.clearData();
    }

    public static void generateAllAssets() {
        JsonObject langObject = new JsonObject();
        for (Material material : GTMaterialHelper.REGISTERED_TOOL_MATERIALS) {
            Pair<ResourceLocation, byte[]> data = MaterialRenderInfoGeneration.INSTANCE.generateRenderInfo(GMConstruct.id(material.getName()), material);
            DATA.addToData((ResourceLocation)data.getFirst(), (byte[])data.getSecond());
            Pair<String, String> entry = LangGeneration.INSTANCE.generateLangEntry(material);
            langObject.addProperty((String)entry.getFirst(), (String)entry.getSecond());
        }
        DATA.addToData(new ResourceLocation("gm_construct", "lang/en_us.json"), langObject.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation resourceLocation) {
        if (packType == PackType.CLIENT_RESOURCES) {
            return DATA.getResource(resourceLocation);
        }
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (packType == PackType.CLIENT_RESOURCES) {
            DATA.listResources(namespace, path, resourceOutput);
        }
    }

    public Set<String> m_5698_(PackType packType) {
        return packType == PackType.CLIENT_RESOURCES ? CLIENT_DOMAINS : Set.of();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metadataSectionSerializer) {
        if (metadataSectionSerializer == PackMetadataSection.f_243696_) {
            return (T)new PackMetadataSection((Component)Component.m_237113_((String)"GMConstruct Dynamic Assets"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES));
        }
        return null;
    }

    public String m_5542_() {
        return this.name;
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
    }

    static {
        CLIENT_DOMAINS.addAll((Collection)Sets.newHashSet((Object[])new String[]{"gm_construct", "minecraft", "forge", "c"}));
    }
}

