/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.data;

import com.mojang.datafixers.util.Pair;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.library.json.JsonRedirect;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.json.MaterialJson;

public class MaterialDataGeneration {
    protected static final MaterialDataGeneration INSTANCE = new MaterialDataGeneration();

    protected Pair<ResourceLocation, byte[]> generateMaterialData(MaterialId key, com.gregtechceu.gtceu.api.data.chemical.material.Material material) {
        OrCondition conditions = new OrCondition(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition("forge", "ingots/" + material.getName())), ConfigEnabledCondition.FORCE_INTEGRATION_MATERIALS});
        MaterialJson json = this.convertMaterialData(new DataMaterial((IMaterial)new Material((ResourceLocation)key, 2, 5, false, false), (ICondition)conditions, null));
        return new Pair((Object)new ResourceLocation("gm_construct", "tinkering/materials/definition/" + material.getName() + ".json"), (Object)MaterialManager.GSON.toJsonTree((Object)json).toString().getBytes(StandardCharsets.UTF_8));
    }

    protected MaterialJson convertMaterialData(DataMaterial data) {
        IMaterial material = data.material;
        JsonRedirect[] redirect = data.redirect;
        if (redirect != null && redirect.length == 0) {
            redirect = null;
        }
        if (material == null) {
            return new MaterialJson(data.condition, null, null, null, null, redirect);
        }
        return new MaterialJson(data.condition, Boolean.valueOf(material.isCraftable()), Integer.valueOf(material.getTier()), Integer.valueOf(material.getSortOrder()), Boolean.valueOf(material.isHidden()), redirect);
    }

    protected record DataMaterial(@Nullable IMaterial material, @Nullable ICondition condition, JsonRedirect[] redirect) {
    }
}

