/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.data;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.mojang.datafixers.util.Pair;
import dev.electrolyte.gm_construct.GMConstruct;
import dev.electrolyte.gm_construct.config.GMCConfig;
import dev.electrolyte.gm_construct.data.MaterialSpriteInfoBuilder;
import java.nio.charset.StandardCharsets;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.materials.MaterialGeneratorInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class MaterialRenderInfoGeneration {
    protected static final MaterialRenderInfoGeneration INSTANCE = new MaterialRenderInfoGeneration();

    protected Pair<ResourceLocation, byte[]> generateRenderInfo(ResourceLocation texture, Material material) {
        JsonObject json = this.getBuilder(texture, material).build((MaterialVariantId)GMConstruct.materialId(material.getName()));
        return new Pair((Object)new ResourceLocation("gm_construct", "tinkering/materials/" + material.getName() + ".json"), (Object)json.toString().getBytes(StandardCharsets.UTF_8));
    }

    private RenderInfoBuilder getBuilder(ResourceLocation texture, Material material) {
        RenderInfoBuilder builder = new RenderInfoBuilder().texture(texture);
        GreyToColorMapping.Builder colorBuilder = GreyToColorMapping.builderFromBlack().addARGB(178, material.getMaterialARGB());
        if (material.getMaterialSecondaryARGB() != -16777216) {
            colorBuilder.addARGB(255, material.getMaterialSecondaryARGB());
        }
        MaterialSpriteInfoBuilder spriteBuilder = new MaterialSpriteInfoBuilder(texture).fallbacks("metal").colorMapper((IColorMapping)colorBuilder.build());
        if (material.hasProperty(PropertyKey.TOOL)) {
            spriteBuilder.meleeHarvest().ranged();
        }
        if (material.hasProperty(PropertyKey.ARMOR)) {
            spriteBuilder.armor();
            if (((Boolean)GMCConfig.GENERATE_PLATE_SHIELD.get()).booleanValue()) {
                spriteBuilder.shieldCore();
            }
        }
        AbstractMaterialSpriteProvider.MaterialSpriteInfo spriteInfo = spriteBuilder.build();
        builder.fallbacks(spriteInfo.getFallbacks());
        int color = spriteInfo.getTransformer().getFallbackColor();
        if (color != -1) {
            builder.color(color & 0xFF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000);
        }
        builder.generator((MaterialGeneratorInfo)spriteInfo);
        return builder;
    }

    public static class RenderInfoBuilder {
        @Nullable
        private ResourceLocation texture = null;
        private String[] fallbacks = new String[0];
        private int color = -1;
        private int luminosity = 0;
        private MaterialGeneratorInfo generator = null;

        public void color(int color) {
            if ((color & 0xFF000000) == 0) {
                color |= 0xFF000000;
            }
            this.color = color;
        }

        public void fallbacks(String ... fallbacks) {
            this.fallbacks = fallbacks;
        }

        @CheckReturnValue
        public JsonObject build(MaterialVariantId id) {
            JsonObject json = new JsonObject();
            MaterialRenderInfo.LOADABLE.serialize((Object)new MaterialRenderInfo(id, this.texture, this.fallbacks, this.color, this.luminosity), json);
            if (this.generator != null) {
                json.add("generator", MaterialGeneratorInfo.LOADABLE.serialize((Object)this.generator));
            }
            return json;
        }

        public RenderInfoBuilder texture(@Nullable ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public RenderInfoBuilder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public RenderInfoBuilder generator(MaterialGeneratorInfo generator) {
            this.generator = generator;
            return this;
        }
    }
}

