/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.data;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.data.sprite.TinkerPartSpriteProvider;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

@CanIgnoreReturnValue
public class MaterialSpriteInfoBuilder {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final ResourceLocation texture;
    private String[] fallbacks = EMPTY_STRING_ARRAY;
    private final ImmutableSet.Builder<MaterialStatsId> statTypes = ImmutableSet.builder();
    @Nullable
    private ISpriteTransformer transformer;
    private boolean variant = false;

    public MaterialSpriteInfoBuilder fallbacks(String ... fallbacks) {
        this.fallbacks = fallbacks;
        return this;
    }

    public MaterialSpriteInfoBuilder colorMapper(IColorMapping mapping) {
        return this.transformer((ISpriteTransformer)new RecolorSpriteTransformer(mapping));
    }

    public MaterialSpriteInfoBuilder variant() {
        return this.variant(true);
    }

    public MaterialSpriteInfoBuilder statType(MaterialStatsId statsId) {
        this.statTypes.add((Object)statsId);
        return this;
    }

    public MaterialSpriteInfoBuilder statType(MaterialStatsId ... statsId) {
        this.statTypes.add((Object[])statsId);
        return this;
    }

    public MaterialSpriteInfoBuilder repairKit() {
        return this.statType(StatlessMaterialStats.REPAIR_KIT.getIdentifier());
    }

    public MaterialSpriteInfoBuilder meleeHarvest() {
        this.statType(HeadMaterialStats.ID);
        this.statType(HandleMaterialStats.ID);
        this.statType(StatlessMaterialStats.BINDING.getIdentifier());
        this.repairKit();
        return this;
    }

    public MaterialSpriteInfoBuilder ranged() {
        this.statType(LimbMaterialStats.ID);
        this.statType(GripMaterialStats.ID);
        this.repairKit();
        return this;
    }

    public MaterialSpriteInfoBuilder maille() {
        this.statType(StatlessMaterialStats.MAILLE.getIdentifier());
        this.statType(TinkerPartSpriteProvider.ARMOR_MAILLE);
        return this;
    }

    public MaterialSpriteInfoBuilder armor() {
        this.statType(TinkerPartSpriteProvider.ARMOR_PLATING);
        for (MaterialStatType type : PlatingMaterialStats.TYPES) {
            this.statType(type.getId());
        }
        this.maille();
        this.repairKit();
        return this;
    }

    public MaterialSpriteInfoBuilder shieldCore() {
        return this.statType(StatlessMaterialStats.SHIELD_CORE.getIdentifier());
    }

    @CheckReturnValue
    public AbstractMaterialSpriteProvider.MaterialSpriteInfo build() {
        if (this.transformer == null) {
            throw new IllegalStateException("Material must have a transformer for a sprite provider");
        }
        ImmutableSet supportedStats = this.statTypes.build();
        if (supportedStats.isEmpty()) {
            throw new IllegalStateException("Material must support at least one stat type");
        }
        return new AbstractMaterialSpriteProvider.MaterialSpriteInfo(this.texture, this.fallbacks, this.transformer, (Set)supportedStats, this.variant);
    }

    public MaterialSpriteInfoBuilder(ResourceLocation texture) {
        this.texture = texture;
    }

    public MaterialSpriteInfoBuilder transformer(@Nullable ISpriteTransformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public MaterialSpriteInfoBuilder variant(boolean variant) {
        this.variant = variant;
        return this;
    }
}

