/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.data;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ArmorProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.mojang.datafixers.util.Pair;
import dev.electrolyte.gm_construct.config.GMCConfig;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.json.MaterialStatJson;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class MaterialStatsGeneration {
    protected static final MaterialStatsGeneration INSTANCE = new MaterialStatsGeneration();

    protected Pair<ResourceLocation, byte[]> generateMaterialStats(Material material) {
        ArrayList<IMaterialStats> stats = new ArrayList<IMaterialStats>();
        if (material.hasProperty(PropertyKey.TOOL)) {
            stats.addAll(this.generateToolStats(material));
        }
        if (material.hasProperty(PropertyKey.ARMOR)) {
            stats.addAll(this.generateArmorStats(material));
        }
        MaterialStatJson json = this.convertMaterialStats(stats);
        return new Pair((Object)new ResourceLocation("gm_construct", "tinkering/materials/stats/" + material.getName() + ".json"), (Object)MaterialManager.GSON.toJsonTree((Object)json).toString().getBytes(StandardCharsets.UTF_8));
    }

    private List<IMaterialStats> generateToolStats(Material material) {
        return List.of(new HeadMaterialStats((int)((double)material.getToolTier().m_6609_() * (Double)GMCConfig.GLOBAL_HEAD_DURABILITY_MODIFIER.get()), (float)((double)material.getToolTier().m_6624_() * (Double)GMCConfig.GLOBAL_HEAD_MINING_SPEED_MODIFIER.get()), (Tier)this.getHarvestTier(material.getToolTier().m_6604_()), (float)((double)material.getToolTier().m_6631_() * (Double)GMCConfig.GLOBAL_HEAD_ATTACK_DAMAGE_MODIFIER.get())), new LimbMaterialStats((int)((double)material.getToolTier().m_6609_() * (Double)GMCConfig.GLOBAL_LIMB_DURABILITY_MODIFIER.get()), (float)((double)material.getMass() * (Double)GMCConfig.GLOBAL_LIMB_DRAW_SPEED_MODIFIER.get()), (float)((double)material.getMass() * (Double)GMCConfig.GLOBAL_LIMB_VELOCITY_MODIFIER.get()), (float)((double)material.getMass() * (Double)GMCConfig.GLOBAL_LIMB_ACCURACY_MODIFIER.get())), new GripMaterialStats((float)(1.0 * (Double)GMCConfig.GLOBAL_GRIP_DURABILITY_MODIFIER.get()), (float)(1.0 * (Double)GMCConfig.GLOBAL_GRIP_ACCURACY_MODIFIER.get()), (float)(1.0 * (Double)GMCConfig.GLOBAL_GRIP_MELEE_DAMAGE_MODIFIER.get())), HandleMaterialStats.multipliers().durability((float)(1.0 * (Double)GMCConfig.GLOBAL_HANDLE_DURABILITY_MODIFIER.get())).miningSpeed((float)(1.0 * (Double)GMCConfig.GLOBAL_HANDLE_MINING_SPEED_MODIFIER.get())).attackDamage((float)(1.0 * (Double)GMCConfig.GLOBAL_HANDLE_ATTACK_DAMAGE_MODIFIER.get())).attackSpeed((float)(1.0 * (Double)GMCConfig.GLOBAL_HANDLE_ATTACK_SPEED_MODIFIER.get())).build(), StatlessMaterialStats.BINDING);
    }

    private List<IMaterialStats> generateArmorStats(Material material) {
        ArmorProperty.ArmorMaterial armorMat = ((ArmorProperty)material.getProperty(PropertyKey.ARMOR)).getArmorMaterial();
        ArrayList<IMaterialStats> stats = new ArrayList<IMaterialStats>();
        for (ArmorItem.Type slotType : ArmorItem.Type.values()) {
            PlatingMaterialStats.Builder armorBuilder = PlatingMaterialStats.builder().durabilityFactor((float)((double)armorMat.m_266425_(slotType) * (Double)GMCConfig.GLOBAL_ARMOR_DURABILITY_MODIFIER.get())).armor((float)armorMat.m_7366_(ArmorItem.Type.BOOTS), (float)armorMat.m_7366_(ArmorItem.Type.LEGGINGS), (float)armorMat.m_7366_(ArmorItem.Type.CHESTPLATE), (float)armorMat.m_7366_(ArmorItem.Type.HELMET)).toughness(armorMat.m_6651_()).knockbackResistance(armorMat.m_6649_());
            PlatingMaterialStats matStats = armorBuilder.build(slotType);
            stats.add((IMaterialStats)matStats);
        }
        if (((Boolean)GMCConfig.GENERATE_PLATE_SHIELD.get()).booleanValue()) {
            stats.add((IMaterialStats)PlatingMaterialStats.builder().shieldDurability((int)((double)armorMat.m_266425_(ArmorItem.Type.CHESTPLATE) * (Double)GMCConfig.GLOBAL_SHIELD_DURABILITY_MODIFIER.get())).toughness(armorMat.m_6651_()).knockbackResistance(armorMat.m_6649_()).buildShield());
        }
        stats.add((IMaterialStats)StatlessMaterialStats.MAILLE);
        return stats;
    }

    private MaterialStatJson convertMaterialStats(List<IMaterialStats> stats) {
        return new MaterialStatJson(stats.stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, stat -> this.encodeStats((IMaterialStats)stat, (MaterialStatType)stat.getType()))));
    }

    private <T extends IMaterialStats> JsonElement encodeStats(IMaterialStats stats, MaterialStatType<T> type) {
        return type.getLoadable().serialize((Object)stats);
    }

    private Tiers getHarvestTier(int tier) {
        return switch (tier) {
            case 0 -> Tiers.WOOD;
            case 1 -> Tiers.STONE;
            case 2 -> Tiers.IRON;
            case 3 -> Tiers.DIAMOND;
            default -> Tiers.NETHERITE;
        };
    }
}

