/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.mojang.datafixers.util.Pair;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.materials.json.MaterialTraitsJson;
import slimeknights.tconstruct.library.materials.traits.MaterialTraits;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.ModifierIds;

public class MaterialTraitsGeneration {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ModifierEntry.class, (Object)ModifierEntry.LOADABLE).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();
    protected static final MaterialTraitsGeneration INSTANCE = new MaterialTraitsGeneration();
    public static final HashMap<String, Pair<ModifierId, Integer>> SPECIAL_TRAITS = new HashMap();

    protected Pair<ResourceLocation, byte[]> generateMaterialTraits(Material material) {
        MaterialTraits.Builder trait = new MaterialTraits.Builder();
        if (SPECIAL_TRAITS.containsKey(material.getName())) {
            Pair<ModifierId, Integer> entry = SPECIAL_TRAITS.get(material.getName());
            trait.setDefaultTraits(List.of(new ModifierEntry((ModifierId)entry.getFirst(), ((Integer)entry.getSecond()).intValue())));
        }
        MaterialTraitsJson json = trait.serialize();
        return new Pair((Object)new ResourceLocation("gm_construct", "tinkering/materials/traits/" + material.getName() + ".json"), (Object)GSON.toJsonTree((Object)json).toString().getBytes(StandardCharsets.UTF_8));
    }

    static {
        SPECIAL_TRAITS.put(GTMaterials.Neutronium.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)3));
        SPECIAL_TRAITS.put(GTMaterials.Osmiridium.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)3));
        SPECIAL_TRAITS.put(GTMaterials.TungstenSteel.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)3));
        SPECIAL_TRAITS.put(GTMaterials.Titanium.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)2));
        SPECIAL_TRAITS.put(GTMaterials.Iridium.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)2));
        SPECIAL_TRAITS.put(GTMaterials.DamascusSteel.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)2));
        SPECIAL_TRAITS.put(GTMaterials.Osmium.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)2));
        SPECIAL_TRAITS.put(GTMaterials.StainlessSteel.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.BlueSteel.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.RedSteel.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.BlackSteel.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.SteelMagnetic.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.reinforced, (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.RoseGold.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.enhanced, (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.Bronze.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.maintained, (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.Invar.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.invariant, (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.Iron.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)TinkerModifiers.magnetic.getId(), (Object)1));
        SPECIAL_TRAITS.put(GTMaterials.Steel.getName(), (Pair<ModifierId, Integer>)Pair.of((Object)ModifierIds.ductile, (Object)1));
    }
}

