/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.datagen;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import dev.electrolyte.gm_construct.helper.GTMaterialHelper;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.IRecipeHelper;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.ICastCreationHelper;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class GMCMaterialRecipeProvider
implements IMaterialRecipeHelper,
IConditionBuilder,
IRecipeHelper,
ICastCreationHelper,
ISmelteryRecipeHelper {
    protected void buildRecipes(Consumer<FinishedRecipe> consumer) {
        this.addMaterialSmeltery(consumer);
    }

    private void addMaterialSmeltery(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.iron, GTMaterials.Iron, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.copper, GTMaterials.Copper, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.slimesteel, (FluidObject<?>)TinkerFluids.moltenSlimesteel, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.amethystBronze, (FluidObject<?>)TinkerFluids.moltenAmethystBronze, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.roseGold, GTMaterials.RoseGold, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.pigIron, (FluidObject<?>)TinkerFluids.moltenPigIron, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.cobalt, GTMaterials.Cobalt, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.steel, GTMaterials.Steel, folder);
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.string, (MaterialVariantId)MaterialIds.roseGold, GTMaterials.RoseGold, 144, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.cinderslime, TinkerFluids.moltenCinderslime, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.queensSlime, (FluidObject<?>)TinkerFluids.moltenQueensSlime, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.hepatizon, (FluidObject<?>)TinkerFluids.moltenHepatizon, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.manyullyn, (FluidObject<?>)TinkerFluids.moltenManyullyn, folder);
        this.materialMeltingComposite(consumer, (MaterialVariantId)MaterialIds.leather, (MaterialVariantId)MaterialIds.ancientHide, (FluidObject)TinkerFluids.moltenDebris, 144, folder);
        this.compatMeltingCasting(consumer, MaterialIds.osmium, GTMaterials.Osmium, folder);
        this.compatMeltingCasting(consumer, MaterialIds.tungsten, GTMaterials.Tungsten, folder);
        this.compatMeltingCasting(consumer, MaterialIds.platinum, GTMaterials.Platinum, folder);
        this.compatMeltingCasting(consumer, MaterialIds.silver, GTMaterials.Silver, folder);
        this.compatMeltingCasting(consumer, MaterialIds.lead, GTMaterials.Lead, folder);
        this.compatMeltingCasting(consumer, MaterialIds.aluminum, (FluidObject)TinkerFluids.moltenAluminum, folder);
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/aluminum")}), (MaterialVariantId)MaterialIds.rock, MaterialIds.whitestoneAluminum, (FluidObject)TinkerFluids.moltenAluminum, 144, folder, "whitestone_from_aluminum");
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/tin")}), (MaterialVariantId)MaterialIds.rock, MaterialIds.whitestoneTin, GTMaterials.Tin, 144, folder, "whitestone_from_tin");
        this.materialComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/zinc")}), (MaterialVariantId)MaterialIds.rock, MaterialIds.whitestoneZinc, GTMaterials.Zinc, 144, folder, "whitestone_from_zinc");
        this.compatMeltingCasting(consumer, MaterialIds.constantan, (FluidObject)TinkerFluids.moltenConstantan, "nickel", folder);
        this.compatMeltingCasting(consumer, MaterialIds.invar, GTMaterials.Invar, "nickel", folder);
        this.compatMeltingCasting(consumer, MaterialIds.electrum, GTMaterials.Electrum, "silver", folder);
        this.compatMeltingCasting(consumer, MaterialIds.bronze, GTMaterials.Bronze, "tin", folder);
        this.materialMeltingComposite(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/uranium")}), (MaterialVariantId)MaterialIds.necroticBone, (MaterialVariantId)MaterialIds.necronium, GTMaterials.Uranium238, 144, folder);
        this.materialMeltingComposite(this.withCondition(consumer, new ICondition[]{new OrCondition(new ICondition[]{this.tagCondition("ingots/brass"), this.tagCondition("ingots/zinc")})}), (MaterialVariantId)MaterialIds.slimewood, (MaterialVariantId)MaterialIds.platedSlimewood, GTMaterials.Brass, 144, folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialIds.gold, GTMaterials.Gold, folder);
    }

    public void materialMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, FluidObject<?> fluid, String folder) {
        super.materialMeltingCasting(consumer, material, fluid, 144, folder);
    }

    public void materialComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, Material material, int amount, String folder) {
        MaterialFluidRecipeBuilder.material((MaterialVariantId)output).setInputId(input).setFluid(material.getFluidTag(), 144).setTemperature(GTMaterialHelper.findTemp(material)).save(consumer, this.location(folder + "composite/" + output.getLocation('_').m_135815_()));
    }

    public void materialMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialVariantId materialId, Material material, String folder) {
        MaterialFluidRecipeBuilder.material((MaterialVariantId)materialId).setFluid(material.getFluidTag(), 144).setTemperature(GTMaterialHelper.findTemp(material)).save(consumer, this.location(folder + "casting/" + material.getName()));
        MaterialMeltingRecipeBuilder.material((MaterialVariantId)materialId, (int)GTMaterialHelper.findTemp(material), (FluidOutput)FluidOutput.fromFluid((Fluid)material.getFluid(), (int)144)).save(consumer, this.location(folder + "melting/" + material.getName()));
    }

    public void compatMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialId materialId, Material material, String folder) {
        this.materialMeltingCasting((Consumer<FinishedRecipe>)this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + materialId.m_135815_())}), (MaterialVariantId)materialId, material, folder);
    }

    public void compatMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialId materialId, Material material, String altTag, String folder) {
        this.materialMeltingCasting((Consumer<FinishedRecipe>)this.withCondition(consumer, new ICondition[]{new OrCondition(new ICondition[]{this.tagCondition("ingots/" + material.getName()), this.tagCondition("ingots/" + altTag)})}), (MaterialVariantId)materialId, material, folder);
    }

    public void materialComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, Material material, int amount, String folder, String name) {
        MaterialFluidRecipeBuilder.material((MaterialVariantId)output).setInputId(input).setFluid(material.getFluidTag(), amount).setTemperature(GTMaterialHelper.findTemp(material)).save(consumer, this.location(folder + "composite/" + name));
    }

    public void materialMeltingComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, Material material, int amount, String folder) {
        MaterialMeltingRecipeBuilder.material((MaterialVariantId)output, (int)GTMaterialHelper.findTemp(material), (FluidStack)new FluidStack(material.getFluid(), amount)).save(consumer, this.location(folder + "melting/" + output.getLocation('_').m_135815_()));
        this.materialComposite(consumer, input, output, material, amount, folder);
    }

    public String getModId() {
        return "tconstruct";
    }
}

