/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.datagen;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import dev.electrolyte.gm_construct.data.GMCByproduct;
import dev.electrolyte.gm_construct.helper.GTMaterialHelper;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ItemExistsCondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.data.ItemNameIngredient;
import slimeknights.mantle.recipe.data.ItemNameOutput;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.SmelteryRecipeBuilder;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.ingredient.NoContainerIngredient;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.data.Byproduct;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;

public class GMCSmelteryRecipeProvider
implements ISmelteryRecipeHelper {
    protected void buildRecipes(Consumer<FinishedRecipe> consumer) {
        this.addSmelteryRecipes(consumer);
        this.addFoundryRecipes(consumer);
        this.addCastingRecipes(consumer);
        this.addMeltingRecipes(consumer);
        this.addAlloyRecipes(consumer);
        this.addEntityMeltingRecipes(consumer);
        this.addTagRecipes(consumer);
        this.addCompatRecipes(consumer);
    }

    private void addSmelteryRecipes(Consumer<FinishedRecipe> consumer) {
        String castingFolder = "smeltery/casting/seared/";
        ItemCastingRecipeBuilder.retexturedBasinRecipe((ItemOutput)ItemOutput.fromItem((ItemLike)TinkerSmeltery.smelteryController)).setCast(TinkerTags.Items.SMELTERY_BRICKS, true).setFluidAndTime(new FluidStack(GTMaterials.Copper.getFluid(), 576)).save(consumer, this.prefix((IdAwareObject)TinkerSmeltery.smelteryController, castingFolder));
        String meltingFolder = "smeltery/melting/seared/";
        MeltingRecipeBuilder.melting((Ingredient)NoContainerIngredient.of((ItemLike[])new ItemLike[]{TinkerSmeltery.searedLantern}), (FluidObject)TinkerFluids.searedStone, (int)500, (float)1.0f).addByproduct(TinkerFluids.moltenGlass.result(250)).addByproduct(new FluidStack(GTMaterials.Iron.getFluid(), 48)).save(consumer, this.location(meltingFolder + "lantern"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.searedFluidCannon}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)720), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)2.5f).addByproduct(TinkerFluids.searedStone.result(1000)).addByproduct(TinkerFluids.moltenGlass.result(1250)).save(consumer, this.location(meltingFolder + "fluid_cannon"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.smelteryController}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)576), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)3.5f).addByproduct(TinkerFluids.searedStone.result(1000)).save(consumer, this.location("smeltery/melting/metal/copper/smeltery_controller"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.copperGauge}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)1.0f).addByproduct(TinkerFluids.moltenGlass.result(50)).save(consumer, this.location("smeltery/melting/metal/copper/gauge"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.searedDrain, TinkerSmeltery.searedChute}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)2.5f).addByproduct(TinkerFluids.searedStone.result(1000)).save(consumer, this.location("smeltery/melting/metal/copper/smeltery_io"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.searedDuct}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)2.5f).addByproduct(TinkerFluids.searedStone.result(1000)).save(consumer, this.location("smeltery/melting/metal/cobalt/seared_duct"));
        MeltingRecipeBuilder.melting((Ingredient)NoContainerIngredient.of((ItemLike[])new ItemLike[]{TinkerSmeltery.searedCastingTank}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)2.5f).addByproduct(TinkerFluids.searedStone.result(1000)).addByproduct(TinkerFluids.moltenGlass.result(3000)).save(consumer, this.location(meltingFolder + "seared_casting_tank"));
    }

    private void addFoundryRecipes(Consumer<FinishedRecipe> consumer) {
        String meltingFolder = "smeltery/melting/scorched/";
        MeltingRecipeBuilder.melting((Ingredient)NoContainerIngredient.of((ItemLike[])new ItemLike[]{TinkerSmeltery.scorchedLantern}), (FluidObject)TinkerFluids.scorchedStone, (int)500, (float)1.0f).addByproduct(TinkerFluids.moltenQuartz.result(25)).addByproduct(FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)48)).save(consumer, this.location(meltingFolder + "lantern"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.scorchedFluidCannon}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Cobalt.getFluid(), (int)720), (int)GTMaterialHelper.findTemp(GTMaterials.Cobalt), (float)3.5f).addByproduct(TinkerFluids.scorchedStone.result(1000)).addByproduct(TinkerFluids.moltenQuartz.result(500)).save(consumer, this.location(meltingFolder + "fluid_cannon"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.scorchedDuct}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)2.5f).addByproduct(TinkerFluids.scorchedStone.result(1000)).save(consumer, this.location("smeltery/melting/metal/cobalt/scorched_duct"));
    }

    private void addCastingRecipes(Consumer<FinishedRecipe> consumer) {
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)TinkerCommons.encyclopedia).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), 144)).setCast((ItemLike)Items.f_42517_, true).save(consumer, this.prefix((IdAwareObject)TinkerCommons.encyclopedia, "common/"));
        String folder = "smeltery/casting/";
        ContainerFillingRecipeBuilder.basinRecipe((ItemLike)((ItemLike)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.INGOT_TANK)), (int)144).save(consumer, this.location(folder + "filling/seared_ingot_tank"));
        ContainerFillingRecipeBuilder.basinRecipe((ItemLike)((ItemLike)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.INGOT_GAUGE)), (int)144).save(consumer, this.location(folder + "filling/seared_ingot_gauge"));
        ContainerFillingRecipeBuilder.tableRecipe((ItemLike)TinkerSmeltery.searedLantern, (int)16).save(consumer, this.location(folder + "filling/seared_lantern_pixel"));
        ContainerFillingRecipeBuilder.basinRecipe((ItemLike)((ItemLike)TinkerSmeltery.scorchedTank.get((Enum)SearedTankBlock.TankType.INGOT_TANK)), (int)144).save(consumer, this.location(folder + "filling/scorched_ingot_tank"));
        ContainerFillingRecipeBuilder.basinRecipe((ItemLike)((ItemLike)TinkerSmeltery.scorchedTank.get((Enum)SearedTankBlock.TankType.INGOT_GAUGE)), (int)144).save(consumer, this.location(folder + "filling/scorched_ingot_gauge"));
        ContainerFillingRecipeBuilder.tableRecipe((ItemLike)TinkerSmeltery.scorchedLantern, (int)16).save(consumer, this.location(folder + "filling/scorched_lantern_pixel"));
        String castFolder = "smeltery/casts/";
        this.castCreation(consumer, Tags.Items.INGOTS, TinkerSmeltery.ingotCast, castFolder);
        this.castCreation(consumer, Tags.Items.NUGGETS, TinkerSmeltery.nuggetCast, castFolder);
        this.castCreation(consumer, Tags.Items.GEMS, TinkerSmeltery.gemCast, castFolder);
        this.castCreation(consumer, Tags.Items.RODS, TinkerSmeltery.rodCast, castFolder);
        this.castCreation(this.withCondition(consumer, new ICondition[]{this.tagCondition("plates")}), this.getItemTag("forge", "plates"), TinkerSmeltery.plateCast, castFolder);
        this.castCreation(this.withCondition(consumer, new ICondition[]{this.tagCondition("gears")}), this.getItemTag("forge", "gears"), TinkerSmeltery.gearCast, castFolder);
        this.castCreation(this.withCondition(consumer, new ICondition[]{this.tagCondition("coins")}), this.getItemTag("forge", "coins"), TinkerSmeltery.coinCast, castFolder);
        this.castCreation(this.withCondition(consumer, new ICondition[]{this.tagCondition("wires")}), this.getItemTag("forge", "wires"), TinkerSmeltery.wireCast, castFolder);
        String metalFolder = folder + "metal/";
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)TinkerCommons.goldBars).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), 48)).save(consumer, this.location(metalFolder + "gold/bars"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)Items.f_42436_).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), 1152)).setCast((ItemLike)Items.f_42410_, true).save(consumer, this.location(metalFolder + "gold/apple"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)Items.f_42546_).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), 128)).setCast((ItemLike)Items.f_42575_, true).save(consumer, this.location(metalFolder + "gold/melon"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)Items.f_42677_).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), 128)).setCast((ItemLike)Items.f_42619_, true).save(consumer, this.location(metalFolder + "gold/carrot"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)Items.f_42524_).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), 576)).setCast((ItemLike)Items.f_42451_, true).save(consumer, this.location(metalFolder + "gold/clock"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)Blocks.f_50183_).setFluidAndTime(new FluidStack(GTMaterials.Iron.getFluid(), 48)).save(consumer, this.location(metalFolder + "iron/bars"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)Items.f_42778_).setFluidAndTime(new FluidStack(GTMaterials.Iron.getFluid(), 128)).setCast((ItemLike)Blocks.f_50081_, true).save(consumer, this.location(metalFolder + "iron/lantern"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)Items.f_42779_).setFluidAndTime(new FluidStack(GTMaterials.Iron.getFluid(), 128)).setCast((ItemLike)Blocks.f_50139_, true).save(consumer, this.location(metalFolder + "iron/soul_lantern"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)Items.f_42522_).setFluidAndTime(new FluidStack(GTMaterials.Iron.getFluid(), 576)).setCast((ItemLike)Items.f_42451_, true).save(consumer, this.location(metalFolder + "iron/compass"));
    }

    private void addMeltingRecipes(Consumer<FinishedRecipe> consumer) {
        String metalFolder = "smeltery/melting/metal/";
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.ORES_NETHERITE_SCRAP), (FluidObject)TinkerFluids.moltenDebris, (int)144, (float)2.0f).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[0]).addByproduct(TinkerFluids.moltenNetherite.result(48)).save(consumer, this.location(metalFolder + "molten_debris/ore"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)TinkerTags.Items.INGOTS_NETHERITE_SCRAP), (FluidObject)TinkerFluids.moltenDebris, (int)144, (float)1.0f).save(consumer, this.location(metalFolder + "molten_debris/scrap"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)TinkerTags.Items.NUGGETS_NETHERITE_SCRAP), (FluidObject)TinkerFluids.moltenDebris, (int)144, (float)0.33333334f).save(consumer, this.location(metalFolder + "molten_debris/debris_nugget"));
        MeltingRecipeBuilder.melting((Ingredient)NoContainerIngredient.of((ItemLike[])new ItemLike[]{TinkerSmeltery.copperCan}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)1.0f).save(consumer, this.location(metalFolder + "copper/can"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42161_, Items.f_41861_, Blocks.f_50679_, Blocks.f_50039_, Blocks.f_50032_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(metalFolder + "iron/ingot_1"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42151_, Items.f_42341_, Blocks.f_50625_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)288)).save(consumer, this.location(metalFolder + "iron/ingot_2"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42446_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)432), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)432)).save(consumer, this.location(metalFolder + "iron/bucket"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42522_, Blocks.f_50376_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)576), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)576)).save(consumer, this.location(metalFolder + "iron/ingot_4"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50620_, Blocks.f_50332_, Items.f_42449_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)720), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)720)).save(consumer, this.location(metalFolder + "iron/ingot_5"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50256_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)1008), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)1008)).save(consumer, this.location(metalFolder + "iron/cauldron"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50184_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)176), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)176)).save(consumer, this.location(metalFolder + "iron/chain"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50322_, Blocks.f_50323_, Blocks.f_50324_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)4464), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)4464)).save(consumer, this.location(metalFolder + "iron/anvil"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50183_, Blocks.f_50156_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)48), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)48)).save(consumer, this.location(metalFolder + "iron/nugget_3"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerCommons.ironPlatform}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)160), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)160)).save(consumer, this.location(metalFolder + "iron/platform"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42109_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)64), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)64)).save(consumer, this.location(metalFolder + "iron/tripwire"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50681_, Blocks.f_50682_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)128), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)128)).save(consumer, this.location(metalFolder + "iron/lantern"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerModifiers.ironReinforcement}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(metalFolder + "iron/reinforcement"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42717_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)208), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)208)).setDamagable(new int[]{16}).save(consumer, this.location(metalFolder + "iron/crossbow"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42651_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)112), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)112)).save(consumer, this.location(metalFolder + "iron/horse_armor"));
        int chainIron = 96;
        int chainSteel = 48;
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42464_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)480), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)480)).addByproduct(new FluidStack(GTMaterials.Steel.getFluid(), 240)).setDamagable(new int[]{16}).save(consumer, this.location(metalFolder + "iron/chain_helmet"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42465_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)480), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)768)).addByproduct(new FluidStack(GTMaterials.Steel.getFluid(), 384)).setDamagable(new int[]{16}).save(consumer, this.location(metalFolder + "iron/chain_chestplate"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42466_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)480), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)672)).addByproduct(new FluidStack(GTMaterials.Steel.getFluid(), 336)).setDamagable(new int[]{16}).save(consumer, this.location(metalFolder + "iron/chain_leggings"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42467_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)480), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)384)).addByproduct(new FluidStack(GTMaterials.Steel.getFluid(), 192)).setDamagable(new int[]{16}).save(consumer, this.location(metalFolder + "iron/chain_boots"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)TinkerTags.Items.GOLD_CASTS), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(metalFolder + "gold/cast"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50030_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(metalFolder + "gold/powered_rail"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50326_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)288)).save(consumer, this.location(metalFolder + "gold/pressure_plate"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42524_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)576), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)576)).save(consumer, this.location(metalFolder + "gold/clock"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)1152), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)1152)).save(consumer, this.location(metalFolder + "gold/apple"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42546_, Items.f_42677_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)128), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)128)).save(consumer, this.location(metalFolder + "gold/produce"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerModifiers.goldReinforcement}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(metalFolder + "gold/reinforcement"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerCommons.goldBars}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)48), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)48)).save(consumer, this.location(metalFolder + "gold/nugget_3"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerCommons.goldPlatform}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)160), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)160)).save(consumer, this.location(metalFolder + "gold/platform"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42652_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)1008), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)1008)).save(consumer, this.location(metalFolder + "gold/horse_armor"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42437_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)10368), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)10368)).save(consumer, this.location(metalFolder + "gold/enchanted_apple"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49998_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)144)).addByproduct(new FluidStack(GTMaterials.Copper.getFluid(), 144)).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[0]).save(consumer, this.location(metalFolder + "gold/nether_gold_ore"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50706_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)48), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)48)).addByproduct(new FluidStack(GTMaterials.Copper.getFluid(), 144)).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[0]).save(consumer, this.location(metalFolder + "gold/gilded_blackstone"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50680_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)576), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)576)).save(consumer, this.location(metalFolder + "gold/bell"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152503_, Blocks.f_152502_, Blocks.f_152501_, Blocks.f_152571_, Blocks.f_152573_, Blocks.f_152572_, Blocks.f_152574_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)1296), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)IMeltingRecipe.calcTimeFactor((int)1296)).save(consumer, this.location(metalFolder + "copper/decorative_block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152510_, Blocks.f_152509_, Blocks.f_152508_, Blocks.f_152507_, Blocks.f_152566_, Blocks.f_152565_, Blocks.f_152564_, Blocks.f_152563_, Blocks.f_152578_, Blocks.f_152577_, Blocks.f_152576_, Blocks.f_152575_, Blocks.f_152582_, Blocks.f_152581_, Blocks.f_152580_, Blocks.f_152579_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)320), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)IMeltingRecipe.calcTimeFactor((int)320)).save(consumer, this.location(metalFolder + "copper/cut_block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152570_, Blocks.f_152569_, Blocks.f_152568_, Blocks.f_152567_, Blocks.f_152586_, Blocks.f_152585_, Blocks.f_152584_, Blocks.f_152583_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)160), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)IMeltingRecipe.calcTimeFactor((int)160)).save(consumer, this.location(metalFolder + "copper/cut_slab"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_152587_}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)432), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)IMeltingRecipe.calcTimeFactor((int)432)).save(consumer, this.location(metalFolder + "copper/lightning_rod"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)TinkerTags.Items.COPPER_PLATFORMS), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)160), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)IMeltingRecipe.calcTimeFactor((int)160)).save(consumer, this.location(metalFolder + "copper/platform"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151059_}), (FluidObject)TinkerFluids.moltenAmethyst, (int)100).addByproduct(GTMaterials.Copper.getFluid(288)).save(consumer, this.location("smeltery/melting/amethyst/spyglass"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50729_}), (FluidObject)TinkerFluids.moltenNetherite, (int)144).save(consumer, this.location(metalFolder + "netherite/lodestone"));
        int[] netheriteSizes = new int[]{16, 25};
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42480_}), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(500)).save(consumer, this.location(metalFolder + "netherite/helmet"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42481_}), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(800)).save(consumer, this.location(metalFolder + "netherite/chestplate"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)this.getItemTag("tconstruct", "melting/netherite/tools_costing_7")), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(700)).save(consumer, this.location(metalFolder + "netherite/leggings"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42483_}), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(400)).save(consumer, this.location(metalFolder + "netherite/boots"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)this.getItemTag("tconstruct", "melting/netherite/tools_costing_3")), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(300)).save(consumer, this.location(metalFolder + "netherite/axes"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)this.getItemTag("tconstruct", "melting/netherite/tools_costing_2")), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(200)).save(consumer, this.location(metalFolder + "netherite/sword"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_((TagKey)this.getItemTag("tconstruct", "melting/netherite/tools_costing_1")), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(100)).save(consumer, this.location(metalFolder + "netherite/shovel"));
        MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("tools_complement", "netherite_excavator")}), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(1100)).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition("tools_complement", "netherite_excavator")}), this.location(metalFolder + "netherite/excavator"));
        MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("tools_complement", "netherite_hammer")}), (FluidObject)TinkerFluids.moltenNetherite, (int)144).setDamagable(netheriteSizes).addByproduct(TinkerFluids.moltenDiamond.result(1300)).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition("tools_complement", "netherite_hammer")}), this.location(metalFolder + "netherite/hammer"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerModifiers.silkyCloth}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.RoseGold.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.RoseGold), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(metalFolder + "rose_gold/silky_cloth"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerModifiers.slimesteelReinforcement}), (FluidObject)TinkerFluids.moltenSlimesteel, (int)48).addByproduct(TinkerFluids.moltenObsidian.result(250)).save(consumer, this.location(metalFolder + "slimesteel/reinforcement"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerModifiers.cobaltReinforcement}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Cobalt.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Cobalt), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(metalFolder + "cobalt/reinforcement"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerCommons.cobaltPlatform}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Cobalt.getFluid(), (int)160), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)IMeltingRecipe.calcTimeFactor((int)160)).save(consumer, this.location(metalFolder + "cobalt/platform"));
    }

    private void addAlloyRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/alloys/";
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenSlimesteel, (int)288).addInput(GTMaterials.Iron.getFluid(), 144).addInput(TinkerFluids.skySlime.ingredient(250)).addInput(TinkerFluids.searedStone.ingredient(250)).save(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenSlimesteel, folder));
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenAmethystBronze, (int)144).addInput(GTMaterials.Copper.getFluid(), 144).addInput(TinkerFluids.moltenAmethyst.ingredient(100)).save(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenAmethystBronze, folder));
        AlloyRecipeBuilder.alloy((FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.RoseGold.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.RoseGold)).addInput(GTMaterials.Copper.getFluid(), 144).addInput(GTMaterials.Gold.getFluid(), 144).save(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenRoseGold, folder));
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenPigIron, (int)288).addInput(GTMaterials.Copper.getFluid(), 144).addInput(TinkerFluids.meatSoup.ingredient(500)).addInput(TinkerFluids.honey.ingredient(250)).save(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenPigIron, folder));
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenCinderslime, (int)288).addInput(GTMaterials.Gold.getFluid(), 144).addInput(TinkerFluids.ichor.ingredient(250)).addInput(TinkerFluids.scorchedStone.ingredient(250)).save(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenCinderslime, folder));
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenQueensSlime, (int)288).addInput(GTMaterials.Cobalt.getFluid(), 144).addInput(GTMaterials.Gold.getFluid(), 144).addInput(TinkerFluids.magma.ingredient(250)).save(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenQueensSlime, folder));
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenManyullyn, (int)576).addInput(GTMaterials.Cobalt.getFluid(), 432).addInput(TinkerFluids.moltenDebris.ingredient(144)).save(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenManyullyn, folder));
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenHepatizon, (int)288).addInput(GTMaterials.Copper.getFluid(), 288).addInput(GTMaterials.Cobalt.getFluid(), 144).addInput(TinkerFluids.moltenQuartz.ingredient(100)).save(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenHepatizon, folder));
        ConditionalRecipe.builder().addCondition((ICondition)ConfigEnabledCondition.CHEAPER_NETHERITE_ALLOY).addRecipe(arg_0 -> ((AlloyRecipeBuilder)AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenNetherite, (int)16).addInput(TinkerFluids.moltenDebris.ingredient(64)).addInput(GTMaterials.Gold.getFluid(), 32)).save(arg_0)).addCondition((ICondition)TrueCondition.INSTANCE).addRecipe(arg_0 -> ((AlloyRecipeBuilder)AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenNetherite, (int)16).addInput(TinkerFluids.moltenDebris.ingredient(64)).addInput(GTMaterials.Gold.getFluid(), 64)).save(arg_0)).build(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenNetherite, folder));
        Consumer wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/tin")});
        AlloyRecipeBuilder.alloy((FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Bronze.getFluid(), (int)576), (int)GTMaterialHelper.findTemp(GTMaterials.Bronze)).addInput(GTMaterials.Copper.getFluid(), 432).addInput(GTMaterials.Tin.getFluid(), 144).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenBronze, folder));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/zinc")});
        AlloyRecipeBuilder.alloy((FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Brass.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.Brass)).addInput(GTMaterials.Copper.getFluid(), 144).addInput(GTMaterials.Zinc.getFluid(), 144).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenBrass, folder));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/silver")});
        AlloyRecipeBuilder.alloy((FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Electrum.getFluid(), (int)288), (int)GTMaterialHelper.findTemp(GTMaterials.Electrum)).addInput(GTMaterials.Gold.getFluid(), 144).addInput(GTMaterials.Silver.getFluid(), 144).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenElectrum, folder));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/nickel")});
        AlloyRecipeBuilder.alloy((FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Invar.getFluid(), (int)432), (int)GTMaterialHelper.findTemp(GTMaterials.Invar)).addInput(GTMaterials.Iron.getFluid(), 288).addInput(GTMaterials.Nickel.getFluid(), 144).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenInvar, folder));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/nickel")});
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenConstantan, (int)288).addInput(GTMaterials.Copper.getFluid(), 144).addInput(GTMaterials.Nickel.getFluid(), 144).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenConstantan, folder));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/pewter"), this.tagCondition("ingots/lead")});
        ConditionalRecipe.builder().addCondition(this.tagCondition("ingots/tin")).addRecipe(arg_0 -> ((AlloyRecipeBuilder)AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenPewter, (int)432).addInput(GTMaterials.Tin.getFluid(), 288).addInput(GTMaterials.Lead.getFluid(), 144)).save(arg_0)).addCondition((ICondition)TrueCondition.INSTANCE).addRecipe(arg_0 -> ((AlloyRecipeBuilder)AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenPewter, (int)288).addInput(GTMaterials.Iron.getFluid(), 144).addInput(GTMaterials.Lead.getFluid(), 144)).save(arg_0)).build(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenPewter, folder));
        Function<String, ICondition> fluidTagLoaded = name -> new TagFilledCondition(Registries.f_256808_, Mantle.commonResource((String)name));
        Function<String, TagKey> fluidTag = name -> FluidTags.create((ResourceLocation)Mantle.commonResource((String)name));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/enderium"), this.tagCondition("ingots/lead")});
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenEnderium, (int)288).addInput(GTMaterials.Lead.getFluid(), 432).addInput(TinkerFluids.moltenDiamond.ingredient(100)).addInput(TinkerFluids.moltenEnder.ingredient(500)).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenEnderium, folder));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/lumium"), this.tagCondition("ingots/tin"), this.tagCondition("ingots/silver"), fluidTagLoaded.apply("glowstone")});
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenLumium, (int)576).addInput(GTMaterials.Tin.getFluid(), 432).addInput(GTMaterials.Silver.getFluid(), 144).addInput((FluidIngredient)FluidIngredient.of((TagKey)fluidTag.apply("glowstone"), (int)500)).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenLumium, folder));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/signalum"), this.tagCondition("ingots/copper"), this.tagCondition("ingots/silver"), fluidTagLoaded.apply("redstone")});
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenSignalum, (int)576).addInput(GTMaterials.Copper.getFluid(), 432).addInput(GTMaterials.Silver.getFluid(), 144).addInput(GTMaterials.Redstone.getFluid(), 576).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenSignalum, folder));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/refined_obsidian"), this.tagCondition("ingots/osmium")});
        AlloyRecipeBuilder.alloy((FluidObject)TinkerFluids.moltenRefinedObsidian, (int)144).addInput(TinkerFluids.moltenObsidian.ingredient(250)).addInput(TinkerFluids.moltenDiamond.ingredient(100)).addInput(GTMaterials.Osmium.getFluid(), 144).save(wrapped, this.prefix((IdAwareObject)TinkerFluids.moltenRefinedObsidian, folder));
    }

    private void addEntityMeltingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/entity_melting/";
        String headFolder = "smeltery/entity_melting/heads/";
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20501_, EntityType.f_20458_, EntityType.f_20502_}), (FluidStack)GTMaterials.Iron.getFluid(16), (int)4).save(consumer, this.location(folder + "zombie"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42681_, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.HUSK)}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Iron.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Iron), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(headFolder + "zombie"));
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20562_}), (FluidStack)GTMaterials.Copper.getFluid(16), (int)4).save(consumer, this.location(folder + "drowned"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.DROWNED)}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Copper.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Copper), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(headFolder + "drowned"));
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20511_, EntityType.f_20512_, EntityType.f_20531_}), (FluidStack)GTMaterials.Gold.getFluid(16), (int)4).save(consumer, this.location(folder + "piglin"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_260451_, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.PIGLIN_BRUTE), (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN)}), (FluidOutput)FluidOutput.fromFluid((Fluid)GTMaterials.Gold.getFluid(), (int)144), (int)GTMaterialHelper.findTemp(GTMaterials.Gold), (float)IMeltingRecipe.calcTimeFactor((int)144)).save(consumer, this.location(headFolder + "piglin"));
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20460_}), (FluidStack)GTMaterials.Iron.getFluid(16), (int)4).save(consumer, this.location(folder + "iron_golem"));
    }

    private void addTagRecipes(Consumer<FinishedRecipe> consumer) {
        SmelteryRecipeBuilder.ToolItemMelting EXCAVATOR = new SmelteryRecipeBuilder.ToolItemMelting(11, "tools_complement", "excavator");
        SmelteryRecipeBuilder.ToolItemMelting HAMMER = new SmelteryRecipeBuilder.ToolItemMelting(13, "tools_complement", "hammer");
        SmelteryRecipeBuilder.CommonRecipe[] TOOLS_COMPLEMENT = new SmelteryRecipeBuilder.CommonRecipe[]{SmelteryRecipeBuilder.SHOVEL_PLUS, SmelteryRecipeBuilder.SWORD, SmelteryRecipeBuilder.AXES, EXCAVATOR, HAMMER};
        SmelteryRecipeBuilder.CommonRecipe[] MEKANISM_ARMOR = new SmelteryRecipeBuilder.CommonRecipe[]{SmelteryRecipeBuilder.HELMET, SmelteryRecipeBuilder.CHESTPLATE, SmelteryRecipeBuilder.LEGGINGS_PLUS, SmelteryRecipeBuilder.BOOTS, new SmelteryRecipeBuilder.ToolItemMelting(6, "mekanism", "shield")};
        this.metal(consumer, GTMaterials.Copper).ore(new IByproduct[]{GMCByproduct.SMALL_GOLD}).metal().dust().plate().gear().coin().sheetmetal().geore().oreberry().wire().common(new SmelteryRecipeBuilder.CommonRecipe[]{SmelteryRecipeBuilder.SWORD, SmelteryRecipeBuilder.AXES, EXCAVATOR, HAMMER}).common(SmelteryRecipeBuilder.ARMOR).toolCostMelting(1, "shovel", false);
        this.metal(consumer, GTMaterials.Iron).ore(new IByproduct[]{GMCByproduct.STEEL}).metal().dust().plate().gear().coin().sheetmetal().geore().oreberry().minecraftTools().toolCostMelting(11, "tools_costing_11").common(new SmelteryRecipeBuilder.CommonRecipe[]{HAMMER}).rod();
        this.metal(consumer, GTMaterials.Cobalt).ore(new IByproduct[]{Byproduct.SMALL_DIAMOND}).metal().dust();
        this.metal(consumer, GTMaterials.Steel).metal().dust().plate().gear().coin().sheetmetal().common(SmelteryRecipeBuilder.TOOLS).common(MEKANISM_ARMOR).wire().rod().toolItemMelting(11, "railcraft", "spike_maul");
        this.metal(consumer, GTMaterials.Gold).metal().ore(new IByproduct[]{GMCByproduct.COBALT}).dust().plate().gear().coin().sheetmetal().geore().oreberry().minecraftTools("golden").common(new SmelteryRecipeBuilder.CommonRecipe[]{EXCAVATOR, HAMMER}).rawOre().singularOre(2.0f).denseOre(6.0f);
        this.molten(consumer, (FluidObject<?>)TinkerFluids.moltenQuartz).ore(new IByproduct[]{GMCByproduct.IRON}).smallGem().dust().gear().geore();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenNetherite).metal().dust().plate().gear().coin();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenSlimesteel).metal();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenAmethystBronze).metal().dust();
        this.metal(consumer, GTMaterials.RoseGold).metal().dust().plate().coin().gear();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenPigIron).metal();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenManyullyn).metal();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenHepatizon).metal();
        this.metal(consumer, TinkerFluids.moltenCinderslime).metal();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenQueensSlime).metal();
        this.metal(consumer, GTMaterials.Tin).ore(new IByproduct[]{GMCByproduct.NICKEL, GMCByproduct.COPPER}).optional().metal().dust().oreberry().plate().gear().coin().common(TOOLS_COMPLEMENT).common(SmelteryRecipeBuilder.ARMOR);
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenAluminum).ore(new IByproduct[]{GMCByproduct.IRON}).optional().metal().dust().oreberry().plate().gear().coin().sheetmetal().wire().rod();
        this.metal(consumer, GTMaterials.Lead).ore(new IByproduct[]{GMCByproduct.SILVER, GMCByproduct.GOLD}).optional().metal().dust().oreberry().plate().gear().coin().common(TOOLS_COMPLEMENT).common(SmelteryRecipeBuilder.ARMOR).sheetmetal().wire();
        this.metal(consumer, GTMaterials.Silver).ore(new IByproduct[]{GMCByproduct.LEAD, GMCByproduct.GOLD}).optional().metal().dust().oreberry().plate().gear().coin().common(TOOLS_COMPLEMENT).common(SmelteryRecipeBuilder.ARMOR).sheetmetal();
        this.metal(consumer, GTMaterials.Nickel).ore(new IByproduct[]{GMCByproduct.PLATINUM, GMCByproduct.IRON}).optional().metal().dust().oreberry().plate().gear().coin().common(TOOLS_COMPLEMENT).common(SmelteryRecipeBuilder.ARMOR).sheetmetal();
        this.metal(consumer, GTMaterials.Zinc).ore(new IByproduct[]{GMCByproduct.TIN, GMCByproduct.COPPER}).optional().metal().dust().oreberry().plate().gear().geore();
        this.metal(consumer, GTMaterials.Platinum).ore(new IByproduct[]{GMCByproduct.GOLD}).optional().metal().dust();
        this.metal(consumer, GTMaterials.Tungsten).ore(new IByproduct[]{GMCByproduct.PLATINUM, GMCByproduct.GOLD}).optional().metal().dust();
        this.metal(consumer, GTMaterials.Osmium).ore(new IByproduct[]{GMCByproduct.IRON}).optional().metal().dust().oreberry().common(SmelteryRecipeBuilder.TOOLS).common(MEKANISM_ARMOR);
        this.metal(consumer, GTMaterials.Uranium238).ore(new IByproduct[]{GMCByproduct.LEAD, GMCByproduct.COPPER}).optional().metal().dust().oreberry().plate().gear().coin().sheetmetal();
        this.metal(consumer, GTMaterials.Bronze).optional().metal().dust().plate().gear().coin().common(TOOLS_COMPLEMENT).common(MEKANISM_ARMOR);
        this.metal(consumer, GTMaterials.Brass).optional().metal().dust().plate().gear();
        this.metal(consumer, GTMaterials.Electrum).optional().metal().dust().plate().gear().coin().common(TOOLS_COMPLEMENT).common(SmelteryRecipeBuilder.ARMOR).sheetmetal().wire();
        this.metal(consumer, GTMaterials.Invar).optional().metal().dust().plate().gear().coin().common(TOOLS_COMPLEMENT).common(SmelteryRecipeBuilder.ARMOR);
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenConstantan).optional().metal().dust().plate().gear().coin().common(TOOLS_COMPLEMENT).common(SmelteryRecipeBuilder.ARMOR).sheetmetal();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenPewter).optional().metal().dust();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenEnderium).optional().metal().dust().plate().gear().coin();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenLumium).optional().metal().dust().plate().gear().coin();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenSignalum).optional().metal().dust().plate().gear().coin();
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenRefinedObsidian).optional().metal().common(SmelteryRecipeBuilder.TOOLS).common(MEKANISM_ARMOR);
        this.metal(consumer, (FluidObject<?>)TinkerFluids.moltenRefinedGlowstone).optional().metal().common(SmelteryRecipeBuilder.TOOLS).common(MEKANISM_ARMOR);
        TagKey dawnstone = this.getFluidTag("forge", "molten_dawnstone");
        this.metal(this.withCondition(consumer, new ICondition[]{new TagFilledCondition(dawnstone)}), "dawnstone", (TagKey<Fluid>)dawnstone).temperature(900).optional().metal().plate();
    }

    private void addCompatRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "compat/";
        ItemNameOutput andesiteAlloy = ItemNameOutput.fromName((ResourceLocation)new ResourceLocation("create", "andesite_alloy"));
        Consumer createConsumer = this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("create")});
        ItemCastingRecipeBuilder.basinRecipe((ItemOutput)andesiteAlloy).setCast((ItemLike)Blocks.f_50334_, true).setFluidAndTime(new FluidStack(GTMaterials.Iron.getFluid(), 16)).save(createConsumer, this.location(folder + "create/andesite_alloy_iron"));
        ItemCastingRecipeBuilder.basinRecipe((ItemOutput)andesiteAlloy).setCast((ItemLike)Blocks.f_50334_, true).setFluidAndTime(new FluidStack(GTMaterials.Zinc.getFluid(), 16)).save(createConsumer, this.location(folder + "create/andesite_alloy_zinc"));
        Consumer wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/refined_glowstone"), this.tagCondition("ingots/osmium")});
        ItemCastingRecipeBuilder.tableRecipe((ItemOutput)ItemOutput.fromTag((TagKey)this.getItemTag("forge", "ingots/refined_glowstone"))).setCast(Tags.Items.DUSTS_GLOWSTONE, true).setFluidAndTime(new FluidStack(GTMaterials.Osmium.getFluid(), 144)).save(wrapped, this.location(folder + "refined_glowstone_ingot"));
        wrapped = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/refined_obsidian"), this.tagCondition("ingots/osmium")});
        ItemCastingRecipeBuilder.tableRecipe((ItemOutput)ItemOutput.fromTag((TagKey)this.getItemTag("forge", "ingots/refined_obsidian"))).setCast(this.getItemTag("forge", "dusts/refined_obsidian"), true).setFluidAndTime(new FluidStack(GTMaterials.Osmium.getFluid(), 144)).save(wrapped, this.location(folder + "refined_obsidian_ingot"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)TinkerMaterials.necroniumBone).setFluidAndTime(new FluidStack(GTMaterials.Uranium238.getFluid(), 144)).setCast(TinkerTags.Items.WITHER_BONES, true).save(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/uranium")}), this.location(folder + "necronium_bone"));
        int goldPerBlock = 16;
        String ceramics = "ceramics";
        String ceramicsFolder = folder + ceramics + "/";
        Function<String, ResourceLocation> ceramicsId = name -> new ResourceLocation(ceramics, name);
        Function<String, Ingredient> ceramicsItem = name -> ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation(ceramics, name)});
        Function<String, ItemOutput> ceramicsOutput = name -> ItemNameOutput.fromName((ResourceLocation)new ResourceLocation(ceramics, name));
        Consumer ceramicsConsumer = this.withCondition(consumer, new ICondition[]{new ModLoadedCondition(ceramics)});
        String porcelainFolder = ceramicsFolder + "porcelain/";
        MeltingRecipeBuilder.melting((Ingredient)ceramicsItem.apply("golden_bricks_slab"), (FluidObject)TinkerFluids.moltenPorcelain, (int)500, (float)1.33f).addByproduct(new FluidStack(GTMaterials.Gold.getFluid(), goldPerBlock / 2)).save(ceramicsConsumer, this.location(porcelainFolder + "golden_bricks_slab"));
        MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{ceramicsId.apply("golden_bricks"), ceramicsId.apply("golden_bricks_stairs"), ceramicsId.apply("golden_bricks_wall")}), (FluidObject)TinkerFluids.moltenPorcelain, (int)1000, (float)2.0f).addByproduct(new FluidStack(GTMaterials.Gold.getFluid(), goldPerBlock)).save(ceramicsConsumer, this.location(porcelainFolder + "golden_bricks_block"));
        String castingFolder = ceramicsFolder + "casting/";
        ItemCastingRecipeBuilder.basinRecipe((ItemOutput)ceramicsOutput.apply("golden_bricks")).setCast(ceramicsItem.apply("porcelain_bricks"), true).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), goldPerBlock)).save(ceramicsConsumer, this.location(castingFolder + "golden_bricks"));
        ItemCastingRecipeBuilder.basinRecipe((ItemOutput)ceramicsOutput.apply("golden_bricks_slab")).setCast(ceramicsItem.apply("porcelain_bricks_slab"), true).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), goldPerBlock / 2)).save(ceramicsConsumer, this.location(castingFolder + "golden_bricks_slab"));
        ItemCastingRecipeBuilder.basinRecipe((ItemOutput)ceramicsOutput.apply("golden_bricks_stairs")).setCast(ceramicsItem.apply("porcelain_bricks_stairs"), true).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), goldPerBlock)).save(ceramicsConsumer, this.location(castingFolder + "golden_bricks_stairs"));
        ItemCastingRecipeBuilder.basinRecipe((ItemOutput)ceramicsOutput.apply("golden_bricks_wall")).setCast(ceramicsItem.apply("porcelain_bricks_wall"), true).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), goldPerBlock)).save(ceramicsConsumer, this.location(castingFolder + "golden_bricks_wall"));
    }

    public void castCreation(Consumer<FinishedRecipe> consumer, Ingredient input, CastItemObject cast, String folder, String name) {
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)cast).setFluidAndTime(new FluidStack(GTMaterials.Gold.getFluid(), 144)).setCast(input, true).setSwitchSlots().save(consumer, this.location(folder + "gold/" + name));
    }

    public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid) {
        return this.molten(consumer, fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal");
    }

    public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, Material material) {
        return SmelteryRecipeBuilder.fluid(consumer, (ResourceLocation)this.location(material.getName()), (Fluid)material.getFluid()).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal").temperature(GTMaterialHelper.findTemp(material));
    }

    public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, String name, TagKey<Fluid> fluid) {
        return SmelteryRecipeBuilder.fluid(consumer, (ResourceLocation)this.location(name), fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal");
    }

    public SmelteryRecipeBuilder molten(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid) {
        return super.molten(consumer, fluid).castingFolder("smeltery/casting").meltingFolder("smeltery/melting");
    }

    public String getModId() {
        return "tconstruct";
    }
}

