/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.helper;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import dev.electrolyte.gm_construct.config.GMCConfig;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.fluids.TinkerFluids;

public class GTMaterialHelper {
    public static HashSet<Material> REGISTERED_TOOL_MATERIALS = new HashSet();

    public static HashSet<Material> getRegisteredMaterials() {
        return GTCEuAPI.materialManager.getRegisteredMaterials().stream().filter(m -> {
            for (String s : (List)GMCConfig.IGNORED_GT_MATERIALS.get()) {
                if (!m.getName().equals(s)) continue;
                return false;
            }
            return m.hasProperty(PropertyKey.TOOL) || m.hasProperty(PropertyKey.ARMOR);
        }).collect(Collectors.toCollection(HashSet::new));
    }

    public static int findTemp(Material material) {
        ResourceLocation fluidLoc = new ResourceLocation("tconstruct", "molten_" + material.getName());
        if (ForgeRegistries.FLUIDS.containsKey(fluidLoc)) {
            return ((Fluid)ForgeRegistries.FLUIDS.getValue(fluidLoc)).getFluidType().getTemperature() - 300;
        }
        int materialTemp = material.getFluid().getFluidType().getTemperature();
        int lava = Fluids.f_76195_.getFluidType().getTemperature();
        int bb = ((ForgeFlowingFluid)TinkerFluids.blazingBlood.get()).getFluidType().getTemperature();
        if (materialTemp <= lava) {
            return materialTemp - 300;
        }
        return Math.min(materialTemp, bb) - 300;
    }
}

