/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.recipes;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import dev.electrolyte.gm_construct.GMConstruct;
import dev.electrolyte.gm_construct.config.GMCConfig;
import dev.electrolyte.gm_construct.helper.GTMaterialHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerToolParts;

public class GMCMaterialMachineRecipes {
    public static void register(Consumer<FinishedRecipe> provider) {
        for (Material material : GTMaterialHelper.REGISTERED_TOOL_MATERIALS) {
            MaterialEntry inputMaterial = material.hasProperty(PropertyKey.GEM) ? new MaterialEntry(TagPrefix.gem, material) : new MaterialEntry(TagPrefix.ingot, material);
            if (((Boolean)GMCConfig.GENERATE_EXTRUDER_RECIPES.get()).booleanValue()) {
                GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.repairKit, 2, TinkerSmeltery.repairKitCast, "repair_kit", provider);
                if (material.hasProperty(PropertyKey.TOOL)) {
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.pickHead, 2, TinkerSmeltery.pickHeadCast, "pick_head", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.hammerHead, 8, TinkerSmeltery.hammerHeadCast, "hammer_head", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.smallAxeHead, 2, TinkerSmeltery.smallAxeHeadCast, "small_axe_head", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.broadAxeHead, 8, TinkerSmeltery.broadAxeHeadCast, "broad_axe_head", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.smallBlade, 2, TinkerSmeltery.smallBladeCast, "small_blade", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.broadBlade, 8, TinkerSmeltery.broadBladeCast, "broad_blade", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.bowLimb, 2, TinkerSmeltery.bowLimbCast, "bow_limb", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.bowGrip, 2, TinkerSmeltery.bowGripCast, "bow_grip", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.toolBinding, 1, TinkerSmeltery.toolBindingCast, "tool_binding", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.toughBinding, 3, TinkerSmeltery.toughBindingCast, "tough_binding", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.adzeHead, 2, TinkerSmeltery.adzeHeadCast, "adze_head", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.largePlate, 4, TinkerSmeltery.largePlateCast, "large_plate", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.toolHandle, 1, TinkerSmeltery.toolHandleCast, "tool_handle", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.toughHandle, 3, TinkerSmeltery.toughHandleCast, "tough_handle", provider);
                }
                if (material.hasProperty(PropertyKey.ARMOR)) {
                    GMCMaterialMachineRecipes.generateArmorExtruderRecipes(inputMaterial, (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.HELMET), 3, TinkerSmeltery.helmetPlatingCast, "helmet_plating", provider);
                    GMCMaterialMachineRecipes.generateArmorExtruderRecipes(inputMaterial, (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.CHESTPLATE), 6, TinkerSmeltery.chestplatePlatingCast, "chestplate_plating", provider);
                    GMCMaterialMachineRecipes.generateArmorExtruderRecipes(inputMaterial, (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.LEGGINGS), 5, TinkerSmeltery.leggingsPlatingCast, "leggings_plating", provider);
                    GMCMaterialMachineRecipes.generateArmorExtruderRecipes(inputMaterial, (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.BOOTS), 2, TinkerSmeltery.bootsPlatingCast, "boots_plating", provider);
                    GMCMaterialMachineRecipes.generateExtruderRecipes(inputMaterial, TinkerToolParts.maille, 2, TinkerSmeltery.mailleCast, "maille", provider);
                }
            }
            if (!((Boolean)GMCConfig.GENERATE_FLUID_SOLIDIFICATION_RECIPES.get()).booleanValue()) continue;
            if (!inputMaterial.material().hasProperty(PropertyKey.FLUID)) {
                GMConstruct.LOGGER.warn("Material {} does not have a fluid, no solidification recipes will be added for this material.", (Object)inputMaterial.material());
                continue;
            }
            GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.repairKit, 2, TinkerSmeltery.repairKitCast, "repair_kit", provider);
            if (inputMaterial.material().hasProperty(PropertyKey.TOOL)) {
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.pickHead, 2, TinkerSmeltery.pickHeadCast, "pick_head", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.hammerHead, 8, TinkerSmeltery.hammerHeadCast, "hammer_head", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.smallAxeHead, 2, TinkerSmeltery.smallAxeHeadCast, "small_axe_head", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.broadAxeHead, 8, TinkerSmeltery.broadAxeHeadCast, "broad_axe_head", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.smallBlade, 2, TinkerSmeltery.smallBladeCast, "small_blade", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.broadBlade, 8, TinkerSmeltery.broadBladeCast, "broad_blade", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.bowLimb, 2, TinkerSmeltery.bowLimbCast, "bow_limb", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.bowGrip, 2, TinkerSmeltery.bowGripCast, "bow_grip", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.toolBinding, 1, TinkerSmeltery.toolBindingCast, "tool_binding", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.toughBinding, 3, TinkerSmeltery.toughBindingCast, "tough_binding", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.adzeHead, 2, TinkerSmeltery.adzeHeadCast, "adze_head", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.largePlate, 4, TinkerSmeltery.largePlateCast, "large_plate", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.toolHandle, 1, TinkerSmeltery.toolHandleCast, "tool_handle", provider);
                GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.toughHandle, 3, TinkerSmeltery.toughHandleCast, "tough_handle", provider);
            }
            if (!inputMaterial.material().hasProperty(PropertyKey.ARMOR)) continue;
            GMCMaterialMachineRecipes.generateArmorSolidificationRecipes(inputMaterial, (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.HELMET), 3, TinkerSmeltery.helmetPlatingCast, "helmet_plating", provider);
            GMCMaterialMachineRecipes.generateArmorSolidificationRecipes(inputMaterial, (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.CHESTPLATE), 6, TinkerSmeltery.chestplatePlatingCast, "chestplate_plating", provider);
            GMCMaterialMachineRecipes.generateArmorSolidificationRecipes(inputMaterial, (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.LEGGINGS), 5, TinkerSmeltery.leggingsPlatingCast, "leggings_plating", provider);
            GMCMaterialMachineRecipes.generateArmorSolidificationRecipes(inputMaterial, (ToolPartItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.BOOTS), 2, TinkerSmeltery.bootsPlatingCast, "boots_plating", provider);
            GMCMaterialMachineRecipes.generateSolidifierRecipes(inputMaterial, TinkerToolParts.maille, 2, TinkerSmeltery.mailleCast, "maille", provider);
        }
    }

    private static void generateExtruderRecipes(MaterialEntry inputMaterial, ItemObject<?> toolPartStack, int materialCost, CastItemObject cast, String path, Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder(GMConstruct.id("extrude_" + inputMaterial.material().getName() + "_to_" + path)).inputItems(inputMaterial, materialCost).notConsumable((Supplier)cast).outputItems(GMCMaterialMachineRecipes.getToolStack(toolPartStack.m_5456_(), inputMaterial.material())).duration((int)(20L * inputMaterial.material().getMass() * (long)materialCost)).EUt((long)GTValues.VA[2]).save(provider);
    }

    private static void generateArmorExtruderRecipes(MaterialEntry inputMaterial, ToolPartItem toolPartStack, int materialCost, CastItemObject cast, String path, Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder(GMConstruct.id("extrude_" + inputMaterial.material().getName() + "_to_" + path)).inputItems(inputMaterial, materialCost).notConsumable((Supplier)cast).outputItems(GMCMaterialMachineRecipes.getToolStack(toolPartStack.m_5456_(), inputMaterial.material())).duration((int)(20L * inputMaterial.material().getMass() * (long)materialCost)).EUt((long)GTValues.VA[2]).save(provider);
    }

    private static void generateSolidifierRecipes(MaterialEntry inputMaterial, ItemObject<?> toolPartStack, int materialCost, CastItemObject cast, String path, Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder(GMConstruct.id("solidify_" + inputMaterial.material().getName() + "_to_" + path)).inputFluids(inputMaterial.material().getFluid(materialCost * 144)).notConsumable((Supplier)cast).outputItems(GMCMaterialMachineRecipes.getToolStack(toolPartStack.m_5456_(), inputMaterial.material())).duration((int)(20L * inputMaterial.material().getMass() * (long)materialCost)).EUt((long)GTValues.VA[2]).save(provider);
    }

    private static void generateArmorSolidificationRecipes(MaterialEntry inputMaterial, ToolPartItem toolPartStack, int materialCost, CastItemObject cast, String path, Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder(GMConstruct.id("solidify_" + inputMaterial.material().getName() + "_to_" + path)).inputFluids(inputMaterial.material().getFluid(materialCost * 144)).notConsumable((Supplier)cast).outputItems(GMCMaterialMachineRecipes.getToolStack((Item)toolPartStack, inputMaterial.material())).duration((int)(20L * inputMaterial.material().getMass() * (long)materialCost)).EUt((long)GTValues.VA[2]).save(provider);
    }

    private static ItemStack getToolStack(Item toolPart, Material material) {
        ItemStack stack = new ItemStack((ItemLike)toolPart);
        stack.m_41784_().m_128359_("Material", GMConstruct.materialId(material.getName()).toString());
        return stack;
    }
}

