/*
 * Decompiled with CFR 0.152.
 */
package dev.electrolyte.gm_construct.recipes;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import dev.electrolyte.gm_construct.GMConstruct;
import dev.electrolyte.gm_construct.config.GMCConfig;
import dev.electrolyte.gm_construct.helper.GTMaterialHelper;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.SmelteryRecipeBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;

public class GMCMaterialRecipes
implements IMaterialRecipeHelper,
ISmelteryRecipeHelper {
    public GMCMaterialRecipes(Consumer<FinishedRecipe> provider) {
        this.register(provider);
    }

    public void register(Consumer<FinishedRecipe> provider) {
        Optional<Fluid> fluid;
        for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            Material smeltsIntoMaterial;
            if (!material.hasProperty(PropertyKey.ORE) || (smeltsIntoMaterial = ((OreProperty)material.getProperty(PropertyKey.ORE)).getDirectSmeltResult()) == null || material.getName().equals(smeltsIntoMaterial.getName()) || !smeltsIntoMaterial.hasProperty(PropertyKey.FLUID) || (fluid = this.getFluid(smeltsIntoMaterial, (TagKey<Fluid>)smeltsIntoMaterial.getFluidTag())).isEmpty()) continue;
            this.metal(provider, material.getName(), fluid.get(), GTMaterialHelper.findTemp(smeltsIntoMaterial)).optional().ore(new IByproduct[0]).metal().dust().plate().gear().coin().rod().wire().sheetmetal().geore();
        }
        for (Material material : GTMaterialHelper.REGISTERED_TOOL_MATERIALS) {
            MaterialId materialId = GMConstruct.materialId(material.getName());
            this.metalMaterialRecipe(provider, (MaterialVariantId)materialId, "tools/materials/", material.getName(), false);
            if (!((Boolean)GMCConfig.GENERATE_MELTING_CASTING_RECIPES.get()).booleanValue() || (fluid = this.getFluid(material, (TagKey<Fluid>)material.getFluidTag())).isEmpty()) continue;
            int temp = GTMaterialHelper.findTemp(material);
            MaterialMeltingRecipeBuilder.material((MaterialVariantId)materialId, (int)temp, (FluidStack)new FluidStack(fluid.get(), 144)).save(provider, this.location("tools/materials/melting/" + material.getName()));
            this.metal(provider, material.getName(), fluid.get(), GTMaterialHelper.findTemp(material)).optional().ore(new IByproduct[0]).metal().dust().plate().gear().coin().rod().wire().sheetmetal().geore();
            MaterialFluidRecipeBuilder.material((MaterialVariantId)materialId).setFluid(material.getFluidTag(), 144).setTemperature(temp).save(provider, this.location("tools/materials/casting/" + material.getName()));
        }
    }

    public SmelteryRecipeBuilder metal(Consumer<FinishedRecipe> consumer, String name, Fluid fluid, int temp) {
        return SmelteryRecipeBuilder.fluid(consumer, (ResourceLocation)this.location(name), (Fluid)fluid).castingFolder("smeltery/casting/metal").meltingFolder("smeltery/melting/metal").temperature(temp);
    }

    public Optional<Fluid> getFluid(Material material, TagKey<Fluid> fluidTag) {
        Fluid output;
        ResourceLocation tagLoc = fluidTag.f_203868_();
        String fluidName = tagLoc.m_135815_();
        ResourceLocation fluidLoc = new ResourceLocation("tconstruct", "molten_" + fluidName);
        if (material.hasProperty(PropertyKey.FLUID)) {
            output = material.getFluid();
        } else if (ForgeRegistries.FLUIDS.containsKey(fluidLoc)) {
            output = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidLoc);
        } else {
            GMConstruct.LOGGER.warn("Material {} does not have a fluid, no smeltery recipes will be added for this material.", (Object)material);
            return Optional.empty();
        }
        return Optional.of(output);
    }

    public String getModId() {
        return "gm_construct";
    }
}

