/* MakeUp - color_utils.glsl
Usefull data for color manipulation.

Javier Garduño - GNU Lesser General Public License v3.0
*/

uniform float day_moment;
uniform float day_mixer;
uniform float night_mixer;

#ifdef UNKNOWN_DIM
  uniform vec3 fogColor;
  uniform vec3 skyColor;
#endif

#include "/Input/Time.png"

// I'm Really Embarrassed

vec3 Gigachard = vec3(0.09,0.12,0.25)/0.8 * NIGHT_BRIGHT;
vec3 Kamunanya = vec3(0.09,0.12,0.2)/0.8 * NIGHT_BRIGHT;
vec3 Trollface = vec3(0.09,0.12,0.2)/1.2 * NIGHT_BRIGHT;

vec3 Rickroll = Gigachard*tNight;
vec3 Acumalaka = Kamunanya*tNight;
vec3 Masbro = Trollface*tNight;

vec3 Amadiketu = vec3(1.0,0.5,0.3);

#if COLOR_SCHEME == 1  // Oranye
  #define OMNI_TINT OmniBright
  #define AMBIENT_MIDDLE_COLOR ((vec3(2.0,0.5,0.1)*tSunset)+(vec3(2.0,0.5,0.1)*tSunrise)+(Rickroll))*1.5*Brightness
  #define AMBIENT_DAY_COLOR vec3(0.9)*Brightness
  #define AMBIENT_NIGHT_COLOR vec3(0.02597646, 0.05195295, 0.069) * NIGHT_BRIGHT

  #define HI_MIDDLE_COLOR ((vec3(0.4,0.55,0.98)*tSunrise)+(vec3(0.4,0.55,0.98)*tSunset)+(Acumalaka))*BrightUp
  #define HI_DAY_COLOR vec3(0.104, 0.26, 0.507)*BrightUp*1.0
  #define HI_NIGHT_COLOR vec3(0.004 ,0.01, 0.0195) * NIGHT_BRIGHT

  #define LOW_MIDDLE_COLOR ((vec3(1.0,0.45,0.1)*tSunrise)+(vec3(1.0,0.45,0.1)*tSunset)+(Masbro))*BrightLow
  #define LOW_DAY_COLOR vec3(0.5,0.6,0.69)*BrightLow
  #define LOW_NIGHT_COLOR vec3(0.025, 0.035, 0.05) * NIGHT_BRIGHT

  #define WATER_COLOR vec3(0.3,0.6,0.9)
#elif COLOR_SCHEME == 2 // Oranye - Green
  #define OMNI_TINT OmniBright
  #define AMBIENT_MIDDLE_COLOR ((vec3(2.0,0.5,0.1)*tSunset)+(vec3(2.0,0.5,0.1)*tSunrise)+(Rickroll))*1.5*Brightness
  #define AMBIENT_DAY_COLOR vec3(0.9)*Brightness
  #define AMBIENT_NIGHT_COLOR vec3(0.02597646, 0.05195295, 0.069) * NIGHT_BRIGHT

  #define HI_MIDDLE_COLOR ((vec3(0.2, 0.5, 0.9)*tSunrise)+(vec3(0.4,0.55,0.98)*tSunset)+(Acumalaka))*BrightUp
  #define HI_DAY_COLOR vec3(0.2, 0.5, 0.9)*BrightUp*1.0
  #define HI_NIGHT_COLOR vec3(0.004 ,0.01, 0.0195) * NIGHT_BRIGHT

  #define LOW_MIDDLE_COLOR ((vec3(0.9,0.7,0.4)*tSunrise)+(vec3(1.0,0.45,0.1)*tSunset)+(Masbro))*BrightLow
  #define LOW_DAY_COLOR vec3(0.3,0.5,0.7)*BrightLow
  #define LOW_NIGHT_COLOR vec3(0.025, 0.035, 0.05) * NIGHT_BRIGHT

  #define WATER_COLOR vec3(0.2,1.0,0.76)
#endif

#if BLOCKLIGHT_TEMP == 1
  #define CANDLE_BASELIGHT vec3(Amadiketu)
#endif

vec3 day_blend(vec3 middle, vec3 day, vec3 night) {
  // f(x) = min(-((x-.25)^2)∙20 + 1.25, 1)
  // g(x) = min(-((x-.75)^2)∙50 + 3.125, 1)

  vec3 day_color = mix(middle, day, day_mixer);
  vec3 night_color = mix(middle, night, night_mixer);

  return mix(day_color, night_color, step(0.5, day_moment));
}

float day_blend_float(float middle, float day, float night) {
  // f(x) = min(-((x-.25)^2)∙20 + 1.25, 1)
  // g(x) = min(-((x-.75)^2)∙50 + 3.125, 1)

  float day_value = mix(middle, day, day_mixer);
  float night_value = mix(middle, night, night_mixer);

  return mix(day_value, night_value, step(0.5, day_moment));
}

// Ambient color luma per hour in exposure calculation
#if !defined UNKNOWN_DIM
  #define EXPOSURE_DAY 1.0
  #define EXPOSURE_MIDDLE 1.0
  #define EXPOSURE_NIGHT 0.01
#else
  #define EXPOSURE_DAY 1.0
  #define EXPOSURE_MIDDLE 1.0
  #define EXPOSURE_NIGHT 1.0
#endif

// Fog parameter per hour
#if VOL_LIGHT == 1 || (VOL_LIGHT == 2 && defined SHADOW_CASTING) || defined UNKNOWN_DIM
    #define FOG_DENSITY 2.5
#else
  #define FOG_DAY 3.0
  #define FOG_MIDDLE 2.0
  #define FOG_NIGHT 3.0
#endif
