vec3 getRainbowColor(float t) {
    // t antara 0.0 sampai 1.0
    if (t < 1.0 / 7.0) return vec3(1.0, 0.0, 0.0);                    
    else if (t < 2.0 / 7.0) return vec3(1.0, 0.5, 0.0);               
    else if (t < 3.0 / 7.0) return vec3(1.0, 1.0, 0.0);               
    else if (t < 4.0 / 7.0) return vec3(0.0, 1.0, 0.0);               
    else if (t < 5.0 / 7.0) return vec3(0.0, 0.0, 1.0);               
    else if (t < 6.0 / 7.0) return vec3(0.29, 0.0, 0.51);             
    else return vec3(0.56, 0.0, 1.0);                                 
}

float seenAfterRain(float rainStep, float directRain) {
	float rawFadeIn = smoothstep(0.92, 0.4, rainStep);
	float fadeIn = pow(rawFadeIn, 0.65);
	float fadeOut = smoothstep(0.25, 0.15, rainStep);
	float isClear = 1.0 - smoothstep(0.05, 0.1, directRain);
	float visibility = fadeIn * (1.0 - fadeOut) * isClear;
	return visibility;
}

vec3 drawRainbow(vec3 worldPos, vec3 viewVec, float skyOffset) {
	float visibility = seenAfterRain(wetness, rainStrength);
	
    vec3 rainbowDir = viewVec * mix(worldPos.x, 0.0, skyOffset * 0.35);
    float angle = acos(dot(viewVec, rainbowDir));
    float rainbowAngle = radians(38.0);
    float thickness = radians(2.5);
    float distance = abs(angle - rainbowAngle);

    float ringShape = exp(-pow(distance / thickness, 2.0));
    float verticalFalloff = smoothstep(0.0, 0.015, worldPos.y);

    float hue = clamp((angle - (rainbowAngle - thickness)) / (2.0 * thickness), 0.0, 1.0);
    vec3 color = getRainbowColor(1.0 - hue);

    float pulse = 0.85 + 0.15 * sin(frameTimeCounter * 3.0 + angle * 20.0);

    return mix(color * ringShape * verticalFalloff * pulse * visibility, vec3(0.0), tNight);
}