#include "/lib/config.glsl"

uniform sampler2D tex;

varying vec2 texcoord;
varying float mat;
varying vec3 worldPos;

uniform vec3 cameraPosition;
uniform sampler2D noisetex;
uniform float frameTimeCounter;

#include "/Input/GetCaustics.glsl"

void main() {
	vec4 block_color = texture2D(tex, texcoord);
	bool isWater = mat == 10008.0;
	bool isGlass = mat == 10079.0;
	
	if (isWater) {
	block_color.rgb *= drawCaustic(block_color.rgb);
	block_color *= 4.0;
	gl_FragData[0] = block_color;
	} else {
	block_color.rgb *= mix(block_color.rgb, block_color.rgb, block_color.a);
    block_color.rgb *= 1.5;
    
    block_color.rgb *= 1.0 - block_color.a;
	
	if (float(isGlass) > 0.5 && block_color.a < 0.35) discard;
	
    gl_FragData[0] = block_color;
    }
}
