/* MakeUp - color_utils.glsl
Usefull data for color manipulation.

Javier Garduño - GNU Lesser General Public License v3.0
*/

uniform float day_moment;
uniform float day_mixer;
uniform float night_mixer;

#ifdef UNKNOWN_DIM
  uniform vec3 fogColor;
  uniform vec3 skyColor;
#endif

  #define OMNI_TINT OmniBright
#define AMBIENT_MIDDLE_COLOR vec3(1.0, 0.75, 0.55) * 1.2 * Brightness
#define AMBIENT_DAY_COLOR vec3(0.82, 0.88, 1.0) * 1.0 * Brightness
#define AMBIENT_NIGHT_COLOR vec3(0.8,0.9,1.0) * 0.355

#define HI_MIDDLE_COLOR vec3(0.35, 0.55, 0.89) * 0.87 * BrightUp       
#define HI_DAY_COLOR vec3(0.45, 0.65, 1.0) * 0.95 * BrightUp    
#define HI_NIGHT_COLOR vec3(0.6, 0.75, 1.0) * 0.15 

#define LOW_MIDDLE_COLOR vec3(1.0, 0.67, 0.42) * 0.7 * BrightLow      
#define LOW_DAY_COLOR vec3(0.6, 0.75, 0.9) * 0.88 * BrightLow          
#define LOW_NIGHT_COLOR vec3(0.6, 0.7, 0.8) * 0.3 


#define WATER_COLOR vec3(0.12, 0.7, 0.75)

  #define CANDLE_BASELIGHT vec3(1.0, 0.8, 0.5) * 0.6

vec3 day_blend(vec3 middle, vec3 day, vec3 night) {
  // f(x) = min(-((x-.25)^2)∙20 + 1.25, 1)
  // g(x) = min(-((x-.75)^2)∙50 + 3.125, 1)

  vec3 day_color = mix(middle, day, day_mixer);
  vec3 night_color = mix(middle, night, night_mixer);

  return mix(day_color, night_color, step(0.5, day_moment));
}

float day_blend_float(float middle, float day, float night) {
  // f(x) = min(-((x-.25)^2)∙20 + 1.25, 1)
  // g(x) = min(-((x-.75)^2)∙50 + 3.125, 1)

  float day_value = mix(middle, day, day_mixer);
  float night_value = mix(middle, night, night_mixer);

  return mix(day_value, night_value, step(0.5, day_moment));
}

// Ambient color luma per hour in exposure calculation
#if !defined UNKNOWN_DIM
  #define EXPOSURE_DAY 1.0
  #define EXPOSURE_MIDDLE 1.0
  #define EXPOSURE_NIGHT 0.01
#else
  #define EXPOSURE_DAY 1.0
  #define EXPOSURE_MIDDLE 1.0
  #define EXPOSURE_NIGHT 1.0
#endif

// Fog parameter per hour
#if VOL_LIGHT == 1 || (VOL_LIGHT == 2 && defined SHADOW_CASTING) || defined UNKNOWN_DIM
    #define FOG_DENSITY 3.0
#else
  #define FOG_DAY 3.0
  #define FOG_MIDDLE 3.0
  #define FOG_NIGHT 3.0
#endif
