#version 130

const int noiseTextureResolution = 256;

varying vec2 texcoord;
varying vec3 lightVector;
varying vec3 sunVec;

uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;

uniform float frameTimeCounter;
uniform float far;
uniform float near;
uniform float rainStrength;
uniform float wetness;
uniform float sunAngle;

uniform vec3 cameraPosition;
uniform vec3 shadowLightPosition;
uniform vec3 sunPosition;

uniform int frameCounter;
uniform int frame_mod;
uniform int worldTime;

uniform float viewHeight;
uniform float viewWidth;
uniform float pixel_size_x;
uniform float pixel_size_y;

float timeVal = sunAngle;

float timefract = worldTime;

float tSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float tNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float tSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float tNight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float lowsunTimeX = (tSunrise + tSunset);
float opPhaseTimeIn = mix(lowsunTimeX, lowsunTimeX*2.0, tNight);
float animationIn = mix(1.0, 0.0, opPhaseTimeIn * 3.0);
float mNight = ((clamp(timeVal, 0.50, 0.53)-0.50) / 0.03   - (clamp(timeVal, 0.96, 1.00)-0.96) / 0.09);
vec3 upVec = normalize(gbufferModelView[1].xyz);

float mtNight = mNight * animationIn;

#define rainbowAdd

#ifdef rainbowAdd
#include "/Input/rainbowFunction.glsl"
#endif

void main() {
    vec4 vclouds;

    vec3 block_color = texture2D(colortex1, texcoord.st).rgb;

	float d = texture2D(depthtex1, texcoord.st).r;
	vec3 worldPos;
	vec4 screenPos = vec4(texcoord, d, 1.0);
	vec4 viewPos = gbufferProjectionInverse * (screenPos * 2.0 - 1.0);
	viewPos /= viewPos.w;
    vec3 nfragpos = normalize(viewPos.xyz);
    float n_u = clamp(dot(nfragpos, upVec), 0.0, 1.0);
	vec4 wPos = gbufferModelViewInverse * viewPos;
	wPos /= wPos.w;
	wPos.xyz = normalize(wPos.xyz);
	vec2 uv = wPos.xz / wPos.y;
	
    if (d < 1.0) {} else {
    if (d > 0.56) {
#ifdef rainbowAdd
	vec3 drawRainbow = drawRainbow(wPos.xyz, normalize(viewPos.xyz), n_u);
	vec3 rainbowConfig = mix(drawRainbow, vec3(0.0), vclouds.a);
	block_color += rainbowConfig;
#endif

	}
	}
    
/*DRAWBUFFERS:14*/
    gl_FragData[0] = vec4(block_color, 1.0);
}