#version 120

const float sunPathRotation = -40.0; // [-80.0 -70.0 -60.0 -50.0 -40.0 -35.0 -30.0 -25.0 -20.0 -15.0 -10.0 -5.0 0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 50.0 60.0 70.0 80.0]

uniform mat4 gbufferModelView;

varying vec2 texcoord;
varying vec3 lightVector;
varying vec3 sunVec;

uniform vec3 shadowLightPosition;

const float PI = radians(180.0);
const float TAU = radians(360.0);

uniform int worldTime;

float timeAngle = worldTime / 24000.0;

vec3 GetuSunVec() {
        const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
        float ang = fract(timeAngle - 0.25);
        ang = (ang + (cos(ang * PI) * - 0.5 + 0.5 - ang) * 0.333) * TAU;
        return vec3(- sin(ang), cos(ang) * sunRotationData);
 }

vec3 GetSunVec(vec3 uSunVec) {
        const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
        float ang = fract(timeAngle - 0.25);
        ang = (ang + (cos(ang * PI) * - 0.5 + 0.5 - ang) * 0.333) * TAU;
        return normalize((gbufferModelView * vec4(uSunVec * 2000.0, 1.0)).xyz);
 }
 
void main(){
	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0.xy;
	
	vec3 uSunVec = GetuSunVec();
	sunVec = GetSunVec(uSunVec);
	
	lightVector 	= normalize(shadowLightPosition);
}
