/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSIAssetListener;
import com.g4mesoft.captureplayback.stream.GSICaptureStream;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public abstract class GSAbstractAsset {
    private final GSEAssetType type;
    private boolean added;
    private final List<GSIAssetListener> listeners;

    protected GSAbstractAsset(GSEAssetType type) {
        this.type = type;
        this.added = false;
        this.listeners = new ArrayList<GSIAssetListener>();
    }

    protected abstract GSAbstractAsset copy();

    protected abstract void duplicateFrom(GSAbstractAsset var1);

    protected void onAdded() {
        if (this.added) {
            throw new IllegalStateException("Already added");
        }
        this.added = true;
    }

    protected void onRemoved() {
        if (!this.added) {
            throw new IllegalStateException("Already removed");
        }
        this.added = false;
    }

    void addListener(GSIAssetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.add(listener);
    }

    void removeListener(GSIAssetListener listener) {
        this.listeners.remove(listener);
    }

    protected void dispatchNameChanged(String name) {
        for (GSIAssetListener listener : this.listeners) {
            listener.onNameChanged(name);
        }
    }

    protected void dispatchDerivedAssetAdded(UUID derivedUUID) {
        for (GSIAssetListener listener : this.listeners) {
            listener.onDerivedAssetAdded(derivedUUID);
        }
    }

    protected void dispatchDerivedAssetRemoved(UUID derivedUUID) {
        for (GSIAssetListener listener : this.listeners) {
            listener.onDerivedAssetRemoved(derivedUUID);
        }
    }

    public final GSEAssetType getType() {
        return this.type;
    }

    public boolean isAdded() {
        return this.added;
    }

    public abstract UUID getUUID();

    public abstract String getName();

    public abstract GSIPlaybackStream getPlaybackStream();

    public abstract GSICaptureStream getCaptureStream();

    public abstract Iterator<UUID> getDerivedIterator();

    public abstract GSAbstractAsset getDerivedAsset(UUID var1);
}

