/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAbstractAsset;
import com.g4mesoft.captureplayback.common.asset.GSAssetStorage;

public class GSAssetRef {
    private final GSAssetStorage storage;
    private GSAbstractAsset asset;
    private int cnt;

    GSAssetRef(GSAssetStorage storage, GSAbstractAsset asset) {
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        this.storage = storage;
        this.asset = asset;
        this.cnt = 1;
    }

    private void checkValid() {
        if (!this.valid()) {
            throw new IllegalStateException("Reference is no longer valid");
        }
    }

    public GSAbstractAsset get() {
        this.checkValid();
        return this.asset;
    }

    public GSAssetRef retain() {
        return this.retain(1);
    }

    public GSAssetRef retain(int amount) {
        this.checkValid();
        if (amount <= 0) {
            throw new IllegalArgumentException("amount must be positive!");
        }
        this.cnt += amount;
        return this;
    }

    public void release() {
        this.release(1);
    }

    public void release(int amount) {
        this.checkValid();
        if (amount <= 0) {
            throw new IllegalArgumentException("amount must be positive!");
        }
        if (this.cnt < amount) {
            throw new IllegalStateException("Released too many times");
        }
        this.cnt -= amount;
        if (this.cnt == 0) {
            this.storage.onRefInvalidated(this.asset.getUUID());
            this.invalidate();
        }
    }

    void invalidate() {
        this.asset = null;
    }

    public boolean valid() {
        return this.asset != null;
    }

    public int remaining() {
        return this.cnt;
    }
}

