/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAbstractAsset;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSCompositionAsset;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSSequenceAsset;
import com.g4mesoft.util.GSFileUtil;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;

public final class GSAssetRegistry {
    private static final Map<GSEAssetType, GSFileUtil.GSFileDecoder<? extends GSAbstractAsset>> decoderRegistry = new EnumMap<GSEAssetType, GSFileUtil.GSFileDecoder<? extends GSAbstractAsset>>(GSEAssetType.class);
    private static final Map<GSEAssetType, GSFileUtil.GSFileEncoder<? extends GSAbstractAsset>> encoderRegistry = new EnumMap<GSEAssetType, GSFileUtil.GSFileEncoder<? extends GSAbstractAsset>>(GSEAssetType.class);
    private static final Map<GSEAssetType, Function<GSAssetInfo, ? extends GSAbstractAsset>> constrRegistry = new EnumMap<GSEAssetType, Function<GSAssetInfo, ? extends GSAbstractAsset>>(GSEAssetType.class);

    private GSAssetRegistry() {
    }

    private static <T extends GSAbstractAsset> void register(GSEAssetType type, GSFileUtil.GSFileDecoder<T> decoder, GSFileUtil.GSFileEncoder<T> encoder, Function<GSAssetInfo, T> constr) {
        decoderRegistry.put(type, decoder);
        encoderRegistry.put(type, encoder);
        constrRegistry.put(type, constr);
    }

    public static GSFileUtil.GSFileDecoder<? extends GSAbstractAsset> getDecoder(GSEAssetType assetType) {
        return decoderRegistry.get((Object)assetType);
    }

    public static GSFileUtil.GSFileEncoder<? extends GSAbstractAsset> getEncoder(GSEAssetType assetType) {
        return encoderRegistry.get((Object)assetType);
    }

    public static Function<GSAssetInfo, ? extends GSAbstractAsset> getConstr(GSEAssetType assetType) {
        return constrRegistry.get((Object)assetType);
    }

    static {
        GSAssetRegistry.register(GSEAssetType.COMPOSITION, GSCompositionAsset::read, GSCompositionAsset::write, GSCompositionAsset::new);
        GSAssetRegistry.register(GSEAssetType.SEQUENCE, GSSequenceAsset::read, GSSequenceAsset::write, GSSequenceAsset::new);
    }
}

