/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAbstractAsset;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.stream.GSICaptureStream;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;

public class GSSequenceAsset
extends GSAbstractAsset
implements GSISequenceListener {
    private final GSSequence sequence;

    public GSSequenceAsset(GSAssetInfo info) {
        this(new GSSequence(info.getAssetUUID(), info.getAssetName()));
    }

    public GSSequenceAsset(GSSequence sequence) {
        super(GSEAssetType.SEQUENCE);
        this.sequence = sequence;
    }

    @Override
    protected GSSequenceAsset copy() {
        GSSequence sequence = new GSSequence(this.getUUID(), this.getName());
        GSSequenceAsset asset = new GSSequenceAsset(sequence);
        asset.duplicateFrom(this);
        return asset;
    }

    @Override
    protected void duplicateFrom(GSAbstractAsset other) {
        if (!(other instanceof GSSequenceAsset)) {
            throw new IllegalArgumentException("Expected sequence asset");
        }
        this.sequence.duplicateFrom(((GSSequenceAsset)other).getSequence());
    }

    @Override
    protected void onAdded() {
        super.onAdded();
        this.sequence.addSequenceListener(this);
    }

    @Override
    protected void onRemoved() {
        super.onRemoved();
        this.sequence.removeSequenceListener(this);
    }

    public GSSequence getSequence() {
        return this.sequence;
    }

    @Override
    public UUID getUUID() {
        return this.sequence.getSequenceUUID();
    }

    @Override
    public String getName() {
        return this.sequence.getName();
    }

    @Override
    public GSIPlaybackStream getPlaybackStream() {
        return this.sequence.getPlaybackStream();
    }

    @Override
    public GSICaptureStream getCaptureStream() {
        return this.sequence.getCaptureStream();
    }

    @Override
    public Iterator<UUID> getDerivedIterator() {
        return Collections.emptyIterator();
    }

    @Override
    public GSAbstractAsset getDerivedAsset(UUID assetUUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sequenceNameChanged(String oldName) {
        this.dispatchNameChanged(this.sequence.getName());
    }

    public static GSSequenceAsset read(GSDecodeBuffer buf) throws IOException {
        return new GSSequenceAsset(GSSequence.read(buf));
    }

    public static void write(GSEncodeBuffer buf, GSSequenceAsset asset) throws IOException {
        GSSequence.write(buf, asset.getSequence());
    }
}

