/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition;

import com.g4mesoft.captureplayback.composition.GSICompositionListener;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSTrackEntry {
    private final UUID entryUUID;
    private long offset;
    private GSTrack parent;

    GSTrackEntry(GSTrackEntry other) {
        this(other.getEntryUUID(), other.getOffset());
    }

    GSTrackEntry(UUID entryUUID, long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset must be non-negative");
        }
        this.entryUUID = entryUUID;
        this.offset = offset;
        this.parent = null;
    }

    public GSTrack getParent() {
        return this.parent;
    }

    void onAdded(GSTrack parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Entry already has a parent");
        }
        this.parent = parent;
    }

    void onRemoved(GSTrack parent) {
        if (this.parent != parent) {
            throw new IllegalStateException("Entry does not have specified parent");
        }
        this.parent = null;
    }

    void duplicateFrom(GSTrackEntry other) {
        this.set(other);
    }

    public void set(GSTrackEntry other) {
        this.setOffset(other.getOffset());
    }

    public UUID getEntryUUID() {
        return this.entryUUID;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset must be non-negative");
        }
        if (offset != this.offset) {
            long oldOffset = this.offset;
            this.offset = offset;
            this.dispatchOffsetChanged(this, oldOffset);
        }
    }

    private void dispatchOffsetChanged(GSTrackEntry entry, long oldOffset) {
        if (this.parent != null && this.parent.getParent() != null) {
            for (GSICompositionListener listener : this.parent.getParent().getListeners()) {
                listener.entryOffsetChanged(entry, oldOffset);
            }
        }
    }

    public static GSTrackEntry read(GSDecodeBuffer buf) throws IOException {
        UUID entryUUID = buf.readUUID();
        long offset = buf.readLong();
        return new GSTrackEntry(entryUUID, offset);
    }

    public static void write(GSEncodeBuffer buf, GSTrackEntry entry) throws IOException {
        buf.writeUUID(entry.getEntryUUID());
        buf.writeLong(entry.getOffset());
    }
}

