/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.composition.delta.GSTrackDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackEntryRemovedDelta;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;

public class GSTrackRemovedDelta
extends GSTrackDelta {
    private String name;
    private int color;
    private UUID groupUUID;
    private GSSequence sequence;
    private GSTrackEntryRemovedDelta[] entryDeltas;

    public GSTrackRemovedDelta() {
    }

    public GSTrackRemovedDelta(GSTrack track) {
        this(track.getTrackUUID(), track.getName(), track.getColor(), track.getGroupUUID(), track.getSequence(), track.getEntries());
    }

    public GSTrackRemovedDelta(UUID trackUUID, String name, int color, UUID groupUUID, GSSequence sequence, Collection<GSTrackEntry> entries) {
        super(trackUUID);
        this.name = name;
        this.color = color;
        this.groupUUID = groupUUID;
        this.sequence = sequence;
        this.entryDeltas = new GSTrackEntryRemovedDelta[entries.size()];
        int i = 0;
        for (GSTrackEntry entry : entries) {
            this.entryDeltas[i++] = new GSTrackEntryRemovedDelta(entry);
        }
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        GSTrack track = this.addTrack(composition, this.name, this.color, this.groupUUID);
        track.getSequence().set(this.sequence);
        for (GSTrackEntryRemovedDelta entryDelta : this.entryDeltas) {
            entryDelta.unapply(composition);
        }
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.removeTrack(composition, this.name, this.color, this.groupUUID, this.sequence.getChannels().size(), this.getSequenceEntryCount(this.sequence), this.entryDeltas.length);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.name = buf.readString();
        this.color = buf.readInt();
        this.groupUUID = buf.readUUID();
        this.sequence = GSSequence.read(buf);
        this.entryDeltas = new GSTrackEntryRemovedDelta[buf.readInt()];
        for (int i = 0; i < this.entryDeltas.length; ++i) {
            this.entryDeltas[i] = new GSTrackEntryRemovedDelta();
            this.entryDeltas[i].read(buf);
        }
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeString(this.name);
        buf.writeInt(this.color);
        buf.writeUUID(this.groupUUID);
        GSSequence.write(buf, this.sequence);
        buf.writeInt(this.entryDeltas.length);
        for (GSTrackEntryRemovedDelta entryDelta : this.entryDeltas) {
            entryDelta.write(buf);
        }
    }
}

