/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.gui.GSUnlimitedScrollBarModel;
import com.g4mesoft.captureplayback.panel.GSEContentOpacity;
import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.ui.panel.GSColoredIcon;
import com.g4mesoft.ui.panel.GSEAnchor;
import com.g4mesoft.ui.panel.GSECursorType;
import com.g4mesoft.ui.panel.GSEFill;
import com.g4mesoft.ui.panel.GSETextAlignment;
import com.g4mesoft.ui.panel.GSGridLayoutManager;
import com.g4mesoft.ui.panel.GSIActionListener;
import com.g4mesoft.ui.panel.GSILayoutManager;
import com.g4mesoft.ui.panel.GSIcon;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelContext;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.button.GSButton;
import com.g4mesoft.ui.panel.dropdown.GSDropdown;
import com.g4mesoft.ui.panel.dropdown.GSDropdownAction;
import com.g4mesoft.ui.panel.dropdown.GSDropdownItem;
import com.g4mesoft.ui.panel.dropdown.GSDropdownSubMenu;
import com.g4mesoft.ui.panel.event.GSFocusEvent;
import com.g4mesoft.ui.panel.event.GSIFocusEventListener;
import com.g4mesoft.ui.panel.event.GSIKeyListener;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSKeyEvent;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.panel.field.GSTextField;
import com.g4mesoft.ui.panel.scroll.GSEScrollBarPolicy;
import com.g4mesoft.ui.panel.scroll.GSIScrollBarModel;
import com.g4mesoft.ui.panel.scroll.GSScrollBar;
import com.g4mesoft.ui.panel.scroll.GSScrollPanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSTextUtil;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class GSAbstractEditPanel
extends GSParentPanel {
    private static final int TITLE_PREFERRED_WIDTH = 250;
    private static final int TITLE_MARGIN = 5;
    private static final int ASSET_UUID_RIGHT_MARGIN = 2;
    private static final int TITLE_SEPARATOR_COLOR = -12303292;
    private static final int TITLE_BACKGROUND_COLOR = -15263977;
    private static final GSIcon BACK_ICON = GSPanelContext.getIcon((int)60, (int)32, (int)9, (int)9);
    private static final GSIcon HOVERED_BACK_ICON = GSPanelContext.getIcon((int)69, (int)32, (int)9, (int)9);
    private static final GSIcon DISABLED_BACK_ICON = GSPanelContext.getIcon((int)78, (int)32, (int)9, (int)9);
    private static final class_2561 BACK_TEXT = GSTextUtil.translatable((String)"panel.edit.back");
    private static final GSIcon OPACITY_SELECTED_ICON = new GSColoredIcon(-1, 4, 4);
    private static final class_2561 OPACITY_TEXT = GSTextUtil.translatable((String)"panel.opacity");
    private static final int CONTENT_EVENT_HANDLER_PRIORITY = 100;
    protected final GSSession session;
    protected final GSButton backButton;
    protected final GSTextField nameField;
    protected final GSTextField handleField;
    protected final GSScrollPanel scrollPanel;
    private final GSContentEventHandler contentHandler;
    private final GSContentEventHandler columnHeaderHandler;
    private final GSContentEventHandler rowHeaderHandler;
    private GSEContentOpacity opacity;
    private boolean editable;

    public GSAbstractEditPanel(GSSession session, GSESessionType type) {
        if (session.getType() != type) {
            throw new IllegalArgumentException("Session is not of type '" + type.getName() + "'");
        }
        this.session = session;
        this.backButton = new GSButton(BACK_ICON, BACK_TEXT);
        this.backButton.setHoveredIcon(HOVERED_BACK_ICON);
        this.backButton.setDisabledIcon(DISABLED_BACK_ICON);
        this.backButton.setBackgroundColor(0);
        this.backButton.setHoveredBackgroundColor(0);
        this.backButton.setDisabledBackgroundColor(0);
        this.backButton.setBorderWidth(0);
        this.backButton.setCursor(GSECursorType.HAND);
        this.nameField = new GSTextField();
        this.nameField.setBackgroundColor(0);
        this.nameField.setTextAlignment(GSETextAlignment.CENTER);
        this.nameField.setBorderWidth(0);
        this.nameField.setVerticalMargin(5);
        this.nameField.setHorizontalMargin(0);
        this.nameField.setFocusLostOnConfirm(true);
        this.handleField = new GSTextField();
        GSAssetHandle handle = session.get(GSSession.ASSET_HANDLE);
        if (handle != null) {
            this.handleField.setText(handle.toString());
        }
        this.handleField.setEditable(false);
        this.handleField.setBackgroundColor(0);
        this.handleField.setTextAlignment(GSETextAlignment.RIGHT);
        this.handleField.setBorderWidth(0);
        this.handleField.setVerticalMargin(5);
        this.handleField.setHorizontalMargin(0);
        this.scrollPanel = new GSScrollPanel();
        this.scrollPanel.setHorizontalScrollBarPolicy(GSEScrollBarPolicy.SCROLLBAR_ALWAYS);
        this.scrollPanel.setVerticalScrollBarPolicy(GSEScrollBarPolicy.SCROLLBAR_AS_NEEDED);
        this.contentHandler = new GSContentEventHandler(true, true);
        this.columnHeaderHandler = new GSContentEventHandler(true, false);
        this.rowHeaderHandler = new GSContentEventHandler(false, true);
        this.setContentOpacity(GSEContentOpacity.FULLY_OPAQUE);
        this.onHorizontalScrollBarChanged(this.scrollPanel.getHorizontalScrollBar());
        this.initLayout();
        this.initEventListeners();
        this.editable = false;
    }

    private void initLayout() {
        this.setLayoutManager((GSILayoutManager)new GSGridLayoutManager());
        this.backButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)0).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST);
        this.add((GSPanel)this.backButton);
        this.nameField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)0).set(GSGridLayoutManager.GRID_WIDTH, (Object)3).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.CENTER).set(GSGridLayoutManager.PREFERRED_WIDTH, (Object)250);
        this.add((GSPanel)this.nameField);
        this.handleField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)2).set(GSGridLayoutManager.GRID_Y, (Object)0).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(0.0f)).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.EAST).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)2);
        this.add((GSPanel)this.handleField);
        this.scrollPanel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)1).set(GSGridLayoutManager.GRID_WIDTH, (Object)3).set(GSGridLayoutManager.WEIGHT_Y, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.BOTH);
        this.add((GSPanel)this.scrollPanel);
    }

    private void initEventListeners() {
        this.backButton.addActionListener(new GSIActionListener(this){

            public void actionPerformed() {
                GSClientController.getInstance().getPrimaryGUI().back();
            }
        });
        this.nameField.addActionListener(() -> this.onNameChanged(this.nameField.getText()));
        this.addKeyEventListener(new GSIKeyListener(){

            public void keyPressed(GSKeyEvent event) {
                switch (event.getKeyCode()) {
                    case 90: {
                        if (!GSAbstractEditPanel.this.isEditable() || event.isModifierHeld(4) || !event.isModifierHeld(2)) break;
                        if (event.isModifierHeld(1)) {
                            GSAbstractEditPanel.this.session.get(GSSession.UNDO_REDO_HISTORY).redo();
                            break;
                        }
                        GSAbstractEditPanel.this.session.get(GSSession.UNDO_REDO_HISTORY).undo();
                        break;
                    }
                    case 89: {
                        if (!GSAbstractEditPanel.this.isEditable() || event.isAnyModifierHeld(5) || !event.isModifierHeld(2)) break;
                        GSAbstractEditPanel.this.session.get(GSSession.UNDO_REDO_HISTORY).redo();
                    }
                }
            }
        });
    }

    protected abstract void onNameChanged(String var1);

    protected void setContent(GSPanel content) {
        GSPanel oldContent = this.scrollPanel.getContent();
        if (oldContent != null) {
            this.contentHandler.uninstall(oldContent);
        }
        this.scrollPanel.setContent(content);
        if (content != null) {
            this.contentHandler.install(content);
        }
    }

    protected void setColumnHeader(GSPanel columnHeader) {
        GSPanel oldColumnHeader = this.scrollPanel.getColumnHeader();
        if (oldColumnHeader != null) {
            this.columnHeaderHandler.uninstall(oldColumnHeader);
        }
        this.scrollPanel.setColumnHeader(columnHeader);
        if (columnHeader != null) {
            this.columnHeaderHandler.install(columnHeader);
        }
    }

    protected void setRowHeader(GSPanel rowHeader) {
        GSPanel oldRowHeader = this.scrollPanel.getRowHeader();
        if (oldRowHeader != null) {
            this.rowHeaderHandler.uninstall(oldRowHeader);
        }
        this.scrollPanel.setRowHeader(rowHeader);
        if (rowHeader != null) {
            this.rowHeaderHandler.install(rowHeader);
        }
    }

    protected void setHorizontalScrollBar(GSScrollBar scrollBar) {
        this.scrollPanel.setHorizontalScrollBar(scrollBar);
        this.onHorizontalScrollBarChanged(scrollBar);
    }

    private void onHorizontalScrollBarChanged(GSScrollBar scrollBar) {
        scrollBar.setModel((GSIScrollBarModel)new GSUnlimitedScrollBarModel());
    }

    protected void onShown() {
        super.onShown();
        this.retrieveSessionFields();
        GSPanel content = this.scrollPanel.getContent();
        if (content != null) {
            content.requestFocus();
        }
    }

    protected void onHidden() {
        super.onHidden();
        this.offerSessionFields();
        this.session.sync();
    }

    protected void retrieveSessionFields() {
        this.setContentOpacity(this.session.get(GSSession.OPACITY));
        this.setXOffset(this.session.get(GSSession.X_OFFSET).floatValue());
        this.setYOffset(this.session.get(GSSession.Y_OFFSET).floatValue());
    }

    protected void offerSessionFields() {
        this.session.set(GSSession.OPACITY, this.getContentOpacity());
        this.session.set(GSSession.X_OFFSET, Float.valueOf(this.getXOffset()));
        this.session.set(GSSession.Y_OFFSET, Float.valueOf(this.getYOffset()));
    }

    public void render(GSIRenderer2D renderer) {
        this.renderTitleBackground(renderer);
        super.render(renderer);
    }

    private void renderTitleBackground(GSIRenderer2D renderer) {
        renderer.drawHLine(0, this.width, this.scrollPanel.getY() - 1, -12303292);
        renderer.fillRect(0, 0, this.width, this.scrollPanel.getY() - 1, -15263977);
    }

    public void populateRightClickMenu(GSDropdown dropdown, int x, int y) {
        GSDropdown opacityMenu = new GSDropdown();
        for (GSEContentOpacity opacity : GSEContentOpacity.OPACITIES) {
            GSIcon icon = this.opacity == opacity ? OPACITY_SELECTED_ICON : null;
            class_5250 text = GSTextUtil.translatable((String)opacity.getName());
            opacityMenu.addItem((GSDropdownItem)new GSDropdownAction(icon, (class_2561)text, () -> this.setContentOpacity(opacity)));
        }
        dropdown.addItem((GSDropdownItem)new GSDropdownSubMenu(OPACITY_TEXT, opacityMenu));
    }

    public GSEContentOpacity getContentOpacity() {
        return this.opacity;
    }

    public void setContentOpacity(GSEContentOpacity opacity) {
        if (opacity == null) {
            throw new IllegalArgumentException("opacity is null");
        }
        this.opacity = opacity;
        this.scrollPanel.setOpacity(opacity.getOpacity());
    }

    public float getXOffset() {
        return this.scrollPanel.getHorizontalScrollBar().getScroll();
    }

    public void setXOffset(float xOffset) {
        this.scrollPanel.getHorizontalScrollBar().setScroll(xOffset);
    }

    public float getYOffset() {
        return this.scrollPanel.getVerticalScrollBar().getScroll();
    }

    public void setYOffset(float yOffset) {
        this.scrollPanel.getVerticalScrollBar().setScroll(yOffset);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    private class GSContentEventHandler
    implements GSIMouseListener,
    GSIKeyListener,
    GSIFocusEventListener {
        private final boolean draggableX;
        private final boolean draggableY;
        private boolean draggingModifier;
        private boolean draggingContent;

        public GSContentEventHandler(boolean draggableX, boolean draggableY) {
            this.draggableX = draggableX;
            this.draggableY = draggableY;
            this.draggingModifier = false;
            this.draggingContent = false;
        }

        public void install(GSPanel content) {
            content.addMouseEventListener((GSIMouseListener)this, 100);
            content.addKeyEventListener((GSIKeyListener)this, 100);
            content.addFocusEventListener((GSIFocusEventListener)this);
        }

        public void uninstall(GSPanel content) {
            content.removeMouseEventListener((GSIMouseListener)this);
            content.removeKeyEventListener((GSIKeyListener)this);
            content.removeFocusEventListener((GSIFocusEventListener)this);
        }

        public void mousePressed(GSMouseEvent event) {
            if (!this.draggingContent && (event.getButton() == 2 || this.draggingModifier && event.getButton() == 0)) {
                this.draggingContent = true;
                event.consume();
            }
        }

        public void mouseReleased(GSMouseEvent event) {
            this.draggingContent = false;
        }

        public void mouseDragged(GSMouseEvent event) {
            if (this.draggingContent) {
                if (this.draggableX) {
                    GSScrollBar hsb = GSAbstractEditPanel.this.scrollPanel.getHorizontalScrollBar();
                    hsb.setScroll(hsb.getScroll() - event.getDragX());
                }
                if (this.draggableY) {
                    GSScrollBar vsb = GSAbstractEditPanel.this.scrollPanel.getVerticalScrollBar();
                    vsb.setScroll(vsb.getScroll() - event.getDragY());
                }
                event.consume();
            }
        }

        public void keyPressed(GSKeyEvent event) {
            if (event.getKeyCode() == 32) {
                this.draggingModifier = true;
                event.consume();
            }
        }

        public void keyReleased(GSKeyEvent event) {
            if (event.getKeyCode() == 32) {
                this.draggingModifier = false;
                event.consume();
            }
        }

        public void focusLost(GSFocusEvent event) {
            this.draggingModifier = false;
            this.draggingContent = false;
        }
    }
}

