/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSICompositionListener;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackGroup;
import com.g4mesoft.captureplayback.gui.GSAbstractEditPanel;
import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.composition.GSCompositionColumnHeaderPanel;
import com.g4mesoft.captureplayback.panel.composition.GSCompositionModelView;
import com.g4mesoft.captureplayback.panel.composition.GSCompositionPanel;
import com.g4mesoft.captureplayback.panel.composition.GSCompositionTrackHeaderPanel;
import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.ui.panel.GSLocation;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelUtil;
import com.g4mesoft.ui.panel.event.GSIKeyListener;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSKeyEvent;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.panel.scroll.GSScrollPanelCorner;
import java.util.UUID;

public class GSCompositionEditPanel
extends GSAbstractEditPanel
implements GSICompositionListener,
GSIModelViewListener,
GSIMouseListener,
GSIKeyListener {
    private final GSComposition composition;
    private final GSCompositionModelView modelView;
    private final GSCompositionPanel content;
    private final GSCompositionColumnHeaderPanel columnHeader;
    private final GSCompositionTrackHeaderPanel trackHeader;
    private int hoveredMouseY;
    private UUID hoveredTrackUUID;
    private boolean changingName;

    public GSCompositionEditPanel(GSSession session) {
        super(session, GSESessionType.COMPOSITION);
        this.composition = session.get(GSSession.COMPOSITION);
        this.modelView = new GSCompositionModelView(this.composition);
        this.modelView.addModelViewListener(this);
        this.content = new GSCompositionPanel(this.composition, this.modelView);
        this.columnHeader = new GSCompositionColumnHeaderPanel(this.modelView);
        this.trackHeader = new GSCompositionTrackHeaderPanel(this.composition, this.modelView);
        this.scrollPanel.setTopLeftCorner((GSPanel)new GSScrollPanelCorner(-14540254));
        this.scrollPanel.setBottomLeftCorner((GSPanel)new GSScrollPanelCorner(-13421773));
        this.scrollPanel.setTopRightCorner((GSPanel)new GSScrollPanelCorner(-14540254));
        this.setContent(this.content);
        this.setColumnHeader(this.columnHeader);
        this.setRowHeader(this.trackHeader);
        this.changingName = false;
        this.compositionNameChanged(null);
        this.addMouseEventListener(this);
        this.addKeyEventListener(this);
        this.setEditable(true);
    }

    @Override
    protected void onShown() {
        this.modelView.installListeners();
        this.modelView.updateModelView();
        this.composition.addCompositionListener(this);
        super.onShown();
    }

    @Override
    protected void onHidden() {
        this.modelView.uninstallListeners();
        this.composition.removeCompositionListener(this);
        super.onHidden();
    }

    @Override
    protected void retrieveSessionFields() {
        super.retrieveSessionFields();
        this.modelView.setGametickWidth(this.session.get(GSSession.GAMETICK_WIDTH));
    }

    @Override
    protected void offerSessionFields() {
        super.offerSessionFields();
        this.session.set(GSSession.GAMETICK_WIDTH, this.modelView.getGametickWidth());
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.content.setEditable(editable);
        this.trackHeader.setEditable(editable);
        this.nameField.setEditable(editable);
    }

    @Override
    protected void onNameChanged(String name) {
        this.changingName = true;
        this.composition.setName(name);
        this.changingName = false;
    }

    @Override
    public void compositionNameChanged(String oldName) {
        if (!this.changingName) {
            this.nameField.setText(this.composition.getName());
        }
    }

    @Override
    public void modelViewChanged() {
        this.updateHoveredTrack();
    }

    public void mouseMoved(GSMouseEvent event) {
        GSLocation viewLocation = GSPanelUtil.getViewLocation((GSPanel)this);
        GSLocation contentViewLocation = GSPanelUtil.getViewLocation((GSPanel)this.content);
        this.hoveredMouseY = event.getY() + viewLocation.getY() - contentViewLocation.getY();
        this.updateHoveredTrack();
    }

    private void updateHoveredTrack() {
        GSTrack hoveredTrack = this.modelView.getTrackFromY(this.hoveredMouseY);
        this.hoveredTrackUUID = hoveredTrack == null ? null : hoveredTrack.getTrackUUID();
    }

    public void keyPressed(GSKeyEvent event) {
        if (event.getKeyCode() == 84 && this.isEditable()) {
            if (event.isModifierHeld(2)) {
                if (this.hoveredTrackUUID != null) {
                    this.composition.removeTrack(this.hoveredTrackUUID);
                }
            } else {
                String trackName = "Track #" + this.composition.getTracks().size();
                int color = 0xFF000000 | (int)(Math.random() * 1.6777215E7);
                GSTrackGroup group = this.composition.addGroup("testgroup");
                this.composition.addTrack(trackName, color, group.getGroupUUID());
            }
        }
    }
}

