/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.captureplayback.gui.GSSearchFilter;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class GSFilteredSet<T extends Comparable<T>>
extends AbstractSet<T> {
    private final GSSearchFilter<T> filter;
    private final SortedSet<T> values;

    public GSFilteredSet(GSSearchFilter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null!");
        }
        this.filter = filter;
        this.values = new TreeSet<T>(filter);
    }

    @Override
    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    @Override
    public boolean add(T value) {
        if (this.filter.filter(value)) {
            return this.values.add(value);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }
}

