/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.captureplayback.gui.GSAbstractEditPanel;
import com.g4mesoft.captureplayback.gui.GSDefaultChannelProvider;
import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.composition.GSIChannelProvider;
import com.g4mesoft.captureplayback.panel.sequence.GSChannelHeaderPanel;
import com.g4mesoft.captureplayback.panel.sequence.GSExpandedColumnModel;
import com.g4mesoft.captureplayback.panel.sequence.GSSequenceButtonPanel;
import com.g4mesoft.captureplayback.panel.sequence.GSSequenceColumnHeaderPanel;
import com.g4mesoft.captureplayback.panel.sequence.GSSequenceInfoPanel;
import com.g4mesoft.captureplayback.panel.sequence.GSSequenceModelView;
import com.g4mesoft.captureplayback.panel.sequence.GSSequencePanel;
import com.g4mesoft.captureplayback.panel.sequence.GSSequencePreviewScrollBar;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.ui.panel.GSLocation;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelUtil;
import com.g4mesoft.ui.panel.event.GSIKeyListener;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSKeyEvent;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.panel.scroll.GSScrollPanelCorner;
import com.google.common.base.Objects;
import java.util.UUID;

public class GSSequenceEditPanel
extends GSAbstractEditPanel
implements GSISequenceListener,
GSIModelViewListener,
GSIMouseListener,
GSIKeyListener {
    private final GSSequence sequence;
    private final GSIChannelProvider channelProvider;
    private final GSExpandedColumnModel expandedColumnModel;
    private final GSSequenceModelView modelView;
    private final GSSequencePanel content;
    private final GSSequenceColumnHeaderPanel columnHeader;
    private final GSChannelHeaderPanel channelHeader;
    private final GSSequenceInfoPanel infoPanel;
    private final GSSequenceButtonPanel buttonPanel;
    private int hoveredMouseX;
    private int hoveredMouseY;
    private int hoveredColumnIndex;
    private UUID hoveredChannelUUID;
    private boolean changingName;

    public GSSequenceEditPanel(GSSession session) {
        this(session, new GSDefaultChannelProvider());
    }

    public GSSequenceEditPanel(GSSession session, GSIChannelProvider channelProvider) {
        super(session, GSESessionType.SEQUENCE);
        this.sequence = session.get(GSSession.SEQUENCE);
        this.channelProvider = channelProvider;
        this.expandedColumnModel = new GSExpandedColumnModel();
        this.modelView = new GSSequenceModelView(this.sequence, this.expandedColumnModel);
        this.modelView.addModelViewListener(this);
        this.content = new GSSequencePanel(this.sequence, this.modelView);
        this.columnHeader = new GSSequenceColumnHeaderPanel(this.sequence, this.modelView);
        this.channelHeader = new GSChannelHeaderPanel(this.sequence, this.modelView, this.content);
        this.infoPanel = new GSSequenceInfoPanel(session);
        this.buttonPanel = new GSSequenceButtonPanel();
        this.setContent(this.content);
        this.setColumnHeader(this.columnHeader);
        this.setRowHeader((GSPanel)this.channelHeader);
        this.setHorizontalScrollBar(new GSSequencePreviewScrollBar(this.sequence, this.modelView));
        this.scrollPanel.setTopLeftCorner((GSPanel)this.infoPanel);
        this.scrollPanel.setBottomLeftCorner((GSPanel)this.buttonPanel);
        this.scrollPanel.setTopRightCorner((GSPanel)new GSScrollPanelCorner(-15263977));
        this.changingName = false;
        this.sequenceNameChanged(null);
        this.addMouseEventListener(this);
        this.addKeyEventListener(this);
        this.setEditable(true);
    }

    @Override
    protected void onShown() {
        this.modelView.installListeners();
        this.modelView.updateModelView();
        this.sequence.addSequenceListener(this);
        super.onShown();
    }

    @Override
    protected void onHidden() {
        this.modelView.uninstallListeners();
        this.setHoveredCell(-1, null);
        this.sequence.removeSequenceListener(this);
        super.onHidden();
    }

    @Override
    protected void retrieveSessionFields() {
        super.retrieveSessionFields();
        GSExpandedColumnModel model = this.modelView.getExpandedColumnModel();
        model.setExpandedColumnRange(this.session.get(GSSession.MIN_EXPANDED_COLUMN), this.session.get(GSSession.MAX_EXPANDED_COLUMN));
    }

    @Override
    protected void offerSessionFields() {
        super.offerSessionFields();
        GSExpandedColumnModel model = this.modelView.getExpandedColumnModel();
        this.session.set(GSSession.MIN_EXPANDED_COLUMN, model.getMinColumnIndex());
        this.session.set(GSSession.MAX_EXPANDED_COLUMN, model.getMaxColumnIndex());
    }

    @Override
    protected void onNameChanged(String name) {
        this.changingName = true;
        this.sequence.setName(name);
        this.changingName = false;
    }

    private void setHoveredCell(int columnIndex, UUID channelUUID) {
        if (columnIndex != this.hoveredColumnIndex || !Objects.equal((Object)channelUUID, (Object)this.hoveredChannelUUID)) {
            this.hoveredChannelUUID = channelUUID;
            this.hoveredColumnIndex = columnIndex;
            this.content.setHoveredCell(columnIndex, channelUUID);
            this.channelHeader.setHoveredChannelUUID(channelUUID);
            this.columnHeader.setHoveredColumn(columnIndex);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.channelHeader.setEditable(editable);
        this.content.setEditable(editable);
        this.nameField.setEditable(editable);
    }

    @Override
    public void sequenceNameChanged(String oldName) {
        if (!this.changingName) {
            this.nameField.setText(this.sequence.getName());
        }
    }

    @Override
    public void modelViewChanged() {
        this.updateHoveredCell();
    }

    public void mouseMoved(GSMouseEvent event) {
        GSLocation viewLocation = GSPanelUtil.getViewLocation((GSPanel)this);
        GSLocation contentViewLocation = GSPanelUtil.getViewLocation((GSPanel)this.content);
        this.hoveredMouseX = event.getX() + viewLocation.getX() - contentViewLocation.getX();
        this.hoveredMouseY = event.getY() + viewLocation.getY() - contentViewLocation.getY();
        this.updateHoveredCell();
    }

    private void updateHoveredCell() {
        int columnIndex = this.modelView.getColumnIndexFromX(this.hoveredMouseX);
        UUID channelUUID = this.content.getDraggedChannelUUID() != null ? this.content.getDraggedChannelUUID() : this.modelView.getChannelUUIDFromView(this.hoveredMouseY);
        this.setHoveredCell(columnIndex, channelUUID);
    }

    public void keyPressed(GSKeyEvent event) {
        switch (event.getKeyCode()) {
            case 84: {
                if (!this.isEditable()) break;
                if (event.isModifierHeld(2)) {
                    if (this.hoveredChannelUUID == null || !this.sequence.removeChannel(this.hoveredChannelUUID)) break;
                    event.consume();
                    break;
                }
                this.sequence.addChannel(this.channelProvider.createChannelInfo(this.sequence));
                event.consume();
                break;
            }
            case 69: {
                if (event.isRepeating()) break;
                if (this.expandedColumnModel.hasExpandedColumn()) {
                    this.expandedColumnModel.clearExpandedColumns();
                } else {
                    this.expandedColumnModel.setExpandedColumnRange(0, Integer.MAX_VALUE);
                }
                event.consume();
            }
        }
    }
}

