/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.server;

import com.g4mesoft.captureplayback.GSCapturePlaybackExtension;
import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetManager;
import com.g4mesoft.captureplayback.common.asset.GSEAssetNamespace;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.module.server.GSAssetHandleArgumentType;
import com.g4mesoft.captureplayback.module.server.GSAssetSuggestionProvider;
import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.captureplayback.session.GSESessionRequestType;
import com.g4mesoft.ui.util.GSTextUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class GSAssetCommand {
    private static final SimpleCommandExceptionType INSUFFICIENT_PERMISSION_EXCEPTION = new SimpleCommandExceptionType((Message)GSTextUtil.translatable((String)"command.assetCommands.insufficientPermission"));

    private GSAssetCommand() {
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, GSEAssetType assetType) {
        LiteralArgumentBuilder command = class_2170.method_9247((String)assetType.getName());
        LiteralArgumentBuilder newCommand = class_2170.method_9247((String)"new");
        for (GSEAssetNamespace namespace : GSEAssetNamespace.values()) {
            newCommand.then(class_2170.method_9247((String)namespace.getName()).then(class_2170.method_9244((String)"assetName", (ArgumentType)StringArgumentType.greedyString()).executes(context -> GSAssetCommand.createAsset((class_2168)context.getSource(), assetType, namespace, StringArgumentType.getString((CommandContext)context, (String)"assetName")))));
        }
        command.then((ArgumentBuilder)newCommand);
        ((LiteralArgumentBuilder)command.then(class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"handle", (ArgumentType)GSAssetHandleArgumentType.handle()).suggests((SuggestionProvider)new GSAssetSuggestionProvider(assetType)).executes(context -> GSAssetCommand.editAsset((class_2168)context.getSource(), assetType, GSAssetHandleArgumentType.getHandle((CommandContext<class_2168>)context, "handle")))))).then(class_2170.method_9247((String)"list").executes(context -> GSAssetCommand.listAssets((class_2168)context.getSource(), assetType)));
        dispatcher.register(command);
    }

    private static int createAsset(class_2168 source, GSEAssetType assetType, GSEAssetNamespace namespace, String assetName) throws CommandSyntaxException {
        class_3222 player = source.method_44023();
        GSCapturePlaybackServerModule module = GSCapturePlaybackExtension.getInstance().getServerModule();
        GSAssetManager assetManager = module.getAssetManager();
        assetManager.createAsset(assetType, namespace, assetName, player.method_5667());
        source.method_9226(() -> GSTextUtil.literal((String)("Asset '" + assetName + "' created successfully.")), false);
        return 1;
    }

    private static int editAsset(class_2168 source, GSEAssetType assetType, GSAssetHandle handle) throws CommandSyntaxException {
        GSAssetCommand.checkPermission(source, handle);
        class_3222 player = source.method_44023();
        GSCapturePlaybackServerModule module = GSCapturePlaybackExtension.getInstance().getServerModule();
        GSAssetInfo info = module.getAssetManager().getInfoFromHandle(handle);
        if (info != null && info.getTypeIndex() == assetType.getIndex() && module.onSessionRequest(player, GSESessionRequestType.REQUEST_START, info.getAssetUUID())) {
            source.method_9226(() -> GSTextUtil.literal((String)("Session of " + GSAssetCommand.toNameString(info) + " started.")), false);
        } else {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Failed to edit asset."));
        }
        return 1;
    }

    private static int listAssets(class_2168 source, GSEAssetType assetType) {
        GSCapturePlaybackServerModule module = GSCapturePlaybackExtension.getInstance().getServerModule();
        String commandPrefix = "/" + assetType.getName() + " edit ";
        class_5250 hintText = GSTextUtil.literal((String)("Edit " + assetType.getName()));
        for (GSAssetInfo info : module.getAssetManager().getStoredHistory()) {
            if (info.getTypeIndex() != assetType.getIndex()) continue;
            source.method_9226(() -> GSAssetCommand.lambda$listAssets$6(info, commandPrefix, (class_2561)hintText), false);
        }
        return 1;
    }

    public static void checkPermission(class_2168 source, GSAssetHandle handle) throws CommandSyntaxException {
        if (!GSAssetCommand.hasPermission(source, handle)) {
            throw INSUFFICIENT_PERMISSION_EXCEPTION.create();
        }
    }

    public static boolean hasPermission(class_2168 source, GSAssetHandle handle) throws CommandSyntaxException {
        if (source.method_9259(2)) {
            return true;
        }
        if (handle == null) {
            return false;
        }
        GSCapturePlaybackServerModule module = GSCapturePlaybackExtension.getInstance().getServerModule();
        return module.getAssetManager().hasPermission(source.method_44023(), handle);
    }

    public static String toNameString(GSAssetInfo info) {
        return "'" + info.getAssetName() + "\u00a7r' (" + String.valueOf(info.getHandle()) + ")";
    }

    private static /* synthetic */ class_2561 lambda$listAssets$6(GSAssetInfo info, String commandPrefix, class_2561 hintText) {
        return class_2564.method_10885((class_2561)GSTextUtil.literal((String)info.getAssetName()).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610(commandPrefix + String.valueOf(info.getHandle()))).method_10949((class_2568)new class_2568.class_10613(hintText)).method_10977(class_124.field_1060)));
    }
}

