/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.server;

import com.g4mesoft.GSExtensionInfo;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.asset.GSAssetHistoryPacket;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfoChangedPacket;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfoRemovedPacket;
import com.g4mesoft.captureplayback.common.asset.GSAssetManager;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistory;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistoryListener;
import com.g4mesoft.captureplayback.common.asset.GSIPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSIPlayerCacheListener;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCacheEntry;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCacheEntryAddedPacket;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCacheEntryRemovedPacket;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCachePacket;
import com.g4mesoft.captureplayback.module.server.GSAssetCommand;
import com.g4mesoft.captureplayback.module.server.GSCaptureCommand;
import com.g4mesoft.captureplayback.module.server.GSPlaybackCommand;
import com.g4mesoft.captureplayback.module.server.GSSessionManager;
import com.g4mesoft.captureplayback.session.GSESessionRequestType;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.core.GSVersion;
import com.g4mesoft.core.server.GSIServerModule;
import com.g4mesoft.core.server.GSIServerModuleManager;
import com.g4mesoft.packet.GSIPacket;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class GSCapturePlaybackServerModule
implements GSIServerModule,
GSIAssetHistoryListener,
GSIPlayerCacheListener {
    public static final String SESSION_CACHE_DIRECTORY = "sessions";
    public static final String COMPOSITION_EXTENSION = ".gcomp";
    public static final GSVersion ASSET_STORAGE_VERSION = new GSVersion(0, 4, 2);
    private GSIServerModuleManager manager;
    private GSAssetManager assetManager;
    private GSIAssetHistory assetHistory;
    private GSIPlayerCache playerCache;
    private GSSessionManager sessionManager;

    public void init(GSIServerModuleManager manager) {
        this.manager = manager;
        this.assetManager = new GSAssetManager(manager);
        this.assetManager.init();
        this.assetHistory = this.assetManager.getStoredHistory();
        this.assetHistory.addListener(this);
        this.playerCache = this.assetManager.getPlayerCache();
        this.playerCache.addListener(this);
        this.sessionManager = new GSSessionManager(manager, this.assetManager, this.getSessionDirectory());
        this.sessionManager.init();
    }

    public void onClose() {
        this.sessionManager.dispose();
        this.sessionManager = null;
        this.assetHistory.removeListener(this);
        this.assetHistory = null;
        this.assetManager.unloadAll();
        this.assetManager = null;
        this.manager = null;
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        GSAssetCommand.registerCommand(dispatcher, GSEAssetType.COMPOSITION);
        GSAssetCommand.registerCommand(dispatcher, GSEAssetType.SEQUENCE);
        GSPlaybackCommand.registerCommand(dispatcher);
        GSCaptureCommand.registerCommand(dispatcher);
    }

    public void onG4mespeedClientJoin(class_3222 player, GSExtensionInfo coreInfo) {
        this.manager.sendPacket((GSIPacket)new GSAssetHistoryPacket(this.assetHistory), player, ASSET_STORAGE_VERSION);
        this.manager.sendPacket((GSIPacket)new GSPlayerCachePacket(this.playerCache), player, ASSET_STORAGE_VERSION);
    }

    public void onPlayerLeave(class_3222 player) {
        this.sessionManager.stopAll(player);
    }

    public boolean onSessionRequest(class_3222 player, GSESessionRequestType requestType, UUID assetUUID) {
        return this.sessionManager.onRequest(player, requestType, assetUUID);
    }

    public void onSessionDeltasReceived(class_3222 player, UUID assetUUID, GSIDelta<GSSession>[] deltas) {
        this.sessionManager.onDeltasReceived(player, assetUUID, deltas);
    }

    private File getSessionDirectory() {
        return new File(this.manager.getCacheFile(), SESSION_CACHE_DIRECTORY);
    }

    public GSAssetManager getAssetManager() {
        return this.assetManager;
    }

    public GSSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void onHistoryChanged(UUID assetUUID) {
        GSAssetInfo info;
        Object packet = assetUUID == null ? new GSAssetHistoryPacket(this.assetHistory) : ((info = this.assetHistory.get(assetUUID)) == null ? new GSAssetInfoRemovedPacket(assetUUID) : new GSAssetInfoChangedPacket(info));
        this.manager.sendPacketToAll((GSIPacket)packet, ASSET_STORAGE_VERSION);
    }

    @Override
    public void onEntryAdded(UUID playerUUID) {
        Object packet;
        if (playerUUID == null) {
            packet = new GSPlayerCachePacket(this.playerCache);
        } else {
            GSPlayerCacheEntry entry = this.playerCache.get(playerUUID);
            packet = new GSPlayerCacheEntryAddedPacket(playerUUID, entry);
        }
        this.manager.sendPacketToAll((GSIPacket)packet, ASSET_STORAGE_VERSION);
    }

    @Override
    public void onEntryRemoved(UUID playerUUID) {
        GSPlayerCacheEntryRemovedPacket packet = new GSPlayerCacheEntryRemovedPacket(playerUUID);
        this.manager.sendPacketToAll((GSIPacket)packet, ASSET_STORAGE_VERSION);
    }
}

