/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.sequence;

import com.g4mesoft.captureplayback.panel.sequence.GSIExpandedColumnModelListener;
import java.util.ArrayList;
import java.util.List;

public class GSExpandedColumnModel {
    private final List<GSIExpandedColumnModelListener> listeners = new ArrayList<GSIExpandedColumnModelListener>();
    private int minColumnIndex;
    private int maxColumnIndex;

    public GSExpandedColumnModel() {
        this.clearExpandedColumns();
    }

    public void addModelListener(GSIExpandedColumnModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.add(listener);
    }

    public void removeModelListener(GSIExpandedColumnModelListener listener) {
        this.listeners.remove(listener);
    }

    public void clearExpandedColumns() {
        this.setExpandedColumn(-1);
    }

    public void setExpandedColumn(int columnIndex) {
        this.setExpandedColumnRange(columnIndex, columnIndex);
    }

    public void setExpandedColumnRange(int minColumnIndex, int maxColumnIndex) {
        if (minColumnIndex < 0 || maxColumnIndex < minColumnIndex) {
            minColumnIndex = -1;
            maxColumnIndex = -1;
        }
        if (minColumnIndex != this.minColumnIndex || maxColumnIndex != this.maxColumnIndex) {
            this.minColumnIndex = minColumnIndex;
            this.maxColumnIndex = maxColumnIndex;
            this.dispatchExpandedColumnChangedEvent();
        }
    }

    public void toggleExpandedColumn(int columnIndex) {
        if (this.hasExpandedColumn()) {
            if (columnIndex == this.minColumnIndex) {
                this.setExpandedColumnRange(this.minColumnIndex + 1, this.maxColumnIndex);
            } else if (columnIndex == this.maxColumnIndex) {
                this.setExpandedColumnRange(this.minColumnIndex, this.maxColumnIndex - 1);
            } else if (this.isColumnExpanded(columnIndex)) {
                this.clearExpandedColumns();
            } else {
                this.setExpandedColumn(columnIndex);
            }
        } else {
            this.setExpandedColumn(columnIndex);
        }
    }

    public void includeExpandedColumn(int columnIndex) {
        if (this.hasExpandedColumn()) {
            if (columnIndex < this.minColumnIndex) {
                this.setExpandedColumnRange(columnIndex, this.maxColumnIndex);
            } else if (columnIndex > this.maxColumnIndex) {
                this.setExpandedColumnRange(this.minColumnIndex, columnIndex);
            }
        } else {
            this.setExpandedColumn(columnIndex);
        }
    }

    private void dispatchExpandedColumnChangedEvent() {
        for (GSIExpandedColumnModelListener listener : this.listeners) {
            listener.onExpandedColumnChanged(this.minColumnIndex, this.maxColumnIndex);
        }
    }

    public boolean isColumnExpanded(int columnIndex) {
        if (!this.hasExpandedColumn()) {
            return false;
        }
        if (columnIndex < this.minColumnIndex) {
            return false;
        }
        return columnIndex <= this.maxColumnIndex;
    }

    public boolean hasExpandedColumn() {
        return this.minColumnIndex != -1;
    }

    public boolean isSingleExpandedColumn() {
        return this.hasExpandedColumn() && this.minColumnIndex == this.maxColumnIndex;
    }

    public boolean isMultiExpandedColumn() {
        return this.hasExpandedColumn() && this.minColumnIndex != this.maxColumnIndex;
    }

    public int getMinColumnIndex() {
        return this.minColumnIndex;
    }

    public int getMaxColumnIndex() {
        return this.maxColumnIndex;
    }
}

