/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.sequence;

import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.sequence.GSExpandedColumnModel;
import com.g4mesoft.captureplayback.panel.sequence.GSIExpandedColumnModelListener;
import com.g4mesoft.captureplayback.panel.sequence.GSMultiCellInfo;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.ui.panel.GSPanelContext;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSMathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GSSequenceModelView
implements GSISequenceListener,
GSIExpandedColumnModelListener {
    private static final int MINIMUM_MICROTICKS = 2;
    private static final int EXTRA_MICROTICKS = 0;
    private static final int GAMETICK_COLUMN_WIDTH = 30;
    private static final int MULTI_COLUMN_INSETS = 10;
    private static final int MT_COLUMN_WIDTH = 20;
    private static final int MINIMUM_ENTRY_WIDTH = 19;
    private static final int ENTRY_HEIGHT = 11;
    private static final int CHANNEL_LABEL_PADDING = 1;
    private static final int DEFAULT_CHANNEL_SPACING = 1;
    private static final int MINIMUM_CHANNEL_HEIGHT = 11;
    private final GSSequence model;
    private final GSExpandedColumnModel expandedColumnModel;
    private int minimumColumnCount;
    private GSSignalTime modelStartTime;
    private GSSignalTime modelEndTime;
    private int lookupSize;
    private int[] durationLookup;
    private final Map<UUID, Integer> channelUUIDToIndex;
    private final Map<Integer, UUID> channelIndexToUUID;
    private final Map<UUID, Map<Integer, Integer>> multiCellLookup;
    private int channelHeight;
    private int channelSpacing;
    private final List<GSIModelViewListener> listenters;

    public GSSequenceModelView(GSSequence model, GSExpandedColumnModel expandedColumnModel) {
        this.model = model;
        this.expandedColumnModel = expandedColumnModel;
        this.modelStartTime = this.modelEndTime = GSSignalTime.ZERO;
        this.lookupSize = 0;
        this.durationLookup = new int[0];
        this.channelUUIDToIndex = new HashMap<UUID, Integer>();
        this.channelIndexToUUID = new HashMap<Integer, UUID>();
        this.multiCellLookup = new HashMap<UUID, Map<Integer, Integer>>();
        this.channelHeight = 11;
        this.channelSpacing = 1;
        this.listenters = new ArrayList<GSIModelViewListener>();
    }

    public void installListeners() {
        this.model.addSequenceListener(this);
        this.expandedColumnModel.addModelListener(this);
    }

    public void uninstallListeners() {
        this.model.removeSequenceListener(this);
        this.expandedColumnModel.removeModelListener(this);
    }

    public void updateModelView() {
        GSIRenderer2D renderer = GSPanelContext.getRenderer();
        this.setChannelHeight(renderer.getTextHeight() + 2);
        this.updateBoundLookup();
        this.updateDurationLookup();
        this.updateChannelIndexLookup();
        this.updateMultiCellLookup();
        this.dispatchModelViewChangedEvent();
    }

    private void updateBoundLookup() {
        this.modelStartTime = GSSignalTime.INFINITY;
        this.modelEndTime = GSSignalTime.ZERO;
        for (GSChannel channel : this.model.getChannels()) {
            for (GSChannelEntry entry : channel.getEntries()) {
                if (this.modelStartTime.isAfter(entry.getStartTime())) {
                    this.modelStartTime = entry.getStartTime();
                }
                if (!this.modelEndTime.isBefore(entry.getEndTime())) continue;
                this.modelEndTime = entry.getEndTime();
            }
        }
        if (this.modelStartTime.isAfter(this.modelEndTime)) {
            this.modelStartTime = GSSignalTime.ZERO;
        }
        this.lookupSize = (int)(this.modelEndTime.getGametick() - this.modelStartTime.getGametick()) + 1;
        this.minimumColumnCount = this.getColumnIndex(this.modelEndTime) + 1;
    }

    private void updateDurationLookup() {
        if (this.lookupSize != this.durationLookup.length) {
            this.durationLookup = new int[this.lookupSize];
        }
        Arrays.fill(this.durationLookup, 1);
        for (GSChannel channel : this.model.getChannels()) {
            for (GSChannelEntry entry : channel.getEntries()) {
                this.updateGameTickDuration(entry.getStartTime());
                this.updateGameTickDuration(entry.getEndTime());
            }
        }
    }

    private void updateGameTickDuration(GSSignalTime time) {
        int lookupOffset = this.getLookupOffset(time);
        if (time.getMicrotick() >= this.durationLookup[lookupOffset]) {
            this.durationLookup[lookupOffset] = time.getMicrotick() + 1;
        }
    }

    public void updateChannelIndexLookup() {
        this.channelUUIDToIndex.clear();
        this.channelIndexToUUID.clear();
        int channelIndex = 0;
        for (UUID channelUUID : this.model.getChannelUUIDs()) {
            this.channelUUIDToIndex.put(channelUUID, channelIndex);
            this.channelIndexToUUID.put(channelIndex, channelUUID);
            ++channelIndex;
        }
    }

    private void updateMultiCellLookup() {
        int[] columnEntryCount = new int[this.lookupSize];
        this.multiCellLookup.clear();
        for (GSChannel channel : this.model.getChannels()) {
            Arrays.fill(columnEntryCount, 0);
            for (GSChannelEntry entry : channel.getEntries()) {
                int startLookupOffset = this.getLookupOffset(entry.getStartTime());
                int endLookupOffset = this.getLookupOffset(entry.getEndTime());
                int n = startLookupOffset;
                columnEntryCount[n] = columnEntryCount[n] + 1;
                if (startLookupOffset == endLookupOffset) continue;
                int n2 = endLookupOffset;
                columnEntryCount[n2] = columnEntryCount[n2] + 1;
            }
            HashMap<Integer, Integer> multiCellCount = new HashMap<Integer, Integer>();
            for (int lookupIndex = 0; lookupIndex < this.lookupSize; ++lookupIndex) {
                int entryCount = columnEntryCount[lookupIndex];
                if (entryCount <= 1) continue;
                multiCellCount.put(lookupIndex, entryCount);
            }
            this.multiCellLookup.put(channel.getChannelUUID(), multiCellCount);
        }
    }

    public int getColumnDuration(int columnIndex) {
        int lookupOffset = this.getLookupOffset(columnIndex);
        int duration = 2;
        if (lookupOffset != -1 && this.durationLookup[lookupOffset] > duration) {
            duration = this.durationLookup[lookupOffset];
        }
        return duration + 0;
    }

    public int getMultiCellCount(UUID channelUUID, int columnIndex) {
        Map<Integer, Integer> multiCellCounts = this.multiCellLookup.get(channelUUID);
        if (multiCellCounts == null) {
            return -1;
        }
        int lookupOffset = this.getLookupOffset(columnIndex);
        if (lookupOffset == -1) {
            return -1;
        }
        Integer count = multiCellCounts.get(lookupOffset);
        return count == null ? -1 : count;
    }

    public boolean isMultiCell(UUID channelUUID, int columnIndex) {
        return this.getMultiCellCount(channelUUID, columnIndex) != -1;
    }

    public Iterator<GSMultiCellInfo> getMultiCellIterator(UUID channelUUID) {
        Map<Integer, Integer> multiCellCounts = this.multiCellLookup.get(channelUUID);
        if (multiCellCounts == null) {
            return Collections.emptyIterator();
        }
        return new GSMultiCellIterator(multiCellCounts.entrySet().iterator());
    }

    private int getLookupOffset(GSSignalTime time) {
        return this.getLookupOffset(this.getColumnIndex(time));
    }

    private int getLookupOffset(int columnIndex) {
        int lookupOffset = (int)(this.getColumnGametick(columnIndex) - this.modelStartTime.getGametick());
        if (lookupOffset < 0 || lookupOffset >= this.lookupSize) {
            return -1;
        }
        return lookupOffset;
    }

    private int getColumnIndexFromLookup(int lookupOffset) {
        return this.getColumnIndex((long)lookupOffset + this.modelStartTime.getGametick());
    }

    public UUID getNextChannelUUID(UUID channelUUID, boolean descending) {
        Integer channelIndex = this.channelUUIDToIndex.get(channelUUID);
        if (channelIndex == null) {
            return null;
        }
        int nextIndex = channelIndex;
        if (descending) {
            if (--nextIndex < 0) {
                nextIndex = this.channelUUIDToIndex.size() - 1;
            }
        } else if (++nextIndex >= this.channelUUIDToIndex.size()) {
            nextIndex = 0;
        }
        return this.channelIndexToUUID.get(nextIndex);
    }

    public GSRectangle modelToView(GSChannelEntry entry) {
        return this.modelToView(entry, null);
    }

    public GSRectangle modelToView(GSChannelEntry entry, GSRectangle dest) {
        int startColumnIndex = this.getColumnIndex(entry.getStartTime());
        int endColumnIndex = this.getColumnIndex(entry.getEndTime());
        if (startColumnIndex < 0) {
            return null;
        }
        UUID channelUUID = entry.getParent().getChannelUUID();
        boolean expanded = this.expandedColumnModel.isColumnExpanded(startColumnIndex);
        if (!expanded && startColumnIndex == endColumnIndex && this.isMultiCell(channelUUID, startColumnIndex)) {
            return null;
        }
        if (dest == null) {
            dest = new GSRectangle();
        }
        dest.x = this.getTimeViewX(channelUUID, entry.getStartTime(), false);
        dest.width = this.getTimeViewX(channelUUID, entry.getEndTime(), true) - dest.x + 1;
        dest.y = this.getEntryY(channelUUID);
        dest.height = 11;
        if (dest.width < 19) {
            dest.x -= (19 - dest.width) / 2;
            dest.width = 19;
        }
        if (entry.getStartTime().isEqual(GSSignalTime.ZERO) && !entry.getType().hasStartEvent()) {
            int x0 = this.getColumnX(0);
            dest.width += dest.x - x0;
            dest.x = x0;
        }
        return dest;
    }

    private int getTimeViewX(UUID channelUUID, GSSignalTime time, boolean endTime) {
        int columnIndex = this.getColumnIndex(time);
        int x = this.getColumnX(columnIndex);
        x = this.expandedColumnModel.isColumnExpanded(columnIndex) ? (x += time.getMicrotick() * 20 + 9) : (this.isMultiCell(channelUUID, columnIndex) ? (x += endTime ? 9 : 19) : (x += 14));
        return x;
    }

    public int getColumnX(int columnIndex) {
        if (this.expandedColumnModel.hasExpandedColumn() && columnIndex >= this.expandedColumnModel.getMinColumnIndex()) {
            int minIndex = this.expandedColumnModel.getMinColumnIndex();
            int maxIndex = this.expandedColumnModel.getMaxColumnIndex();
            int columnX = minIndex * 30;
            for (int i = minIndex; i <= maxIndex && i < columnIndex; ++i) {
                columnX += this.getColumnDuration(i) * 20;
            }
            int trailingColumnCount = columnIndex - maxIndex - 1;
            if (trailingColumnCount > 0) {
                columnX += trailingColumnCount * 30;
            }
            return columnX;
        }
        return columnIndex * 30;
    }

    public int getColumnWidth(int columnIndex) {
        if (this.expandedColumnModel.isColumnExpanded(columnIndex)) {
            return this.getColumnDuration(columnIndex) * 20;
        }
        return 30;
    }

    public int getMicrotickColumnX(int columnIndex, int mt) {
        return this.getColumnX(columnIndex) + 20 * mt;
    }

    public int getMicrotickColumnWidth(int columnIndex, int mt) {
        return 20;
    }

    public int getChannelY(UUID channelUUID) {
        Integer channelIndex = this.channelUUIDToIndex.get(channelUUID);
        if (channelIndex == null) {
            return -1;
        }
        return channelIndex * (this.channelHeight + this.channelSpacing);
    }

    public int getEntryY(UUID channelUUID) {
        return this.getChannelY(channelUUID) + (this.channelHeight - 11) / 2;
    }

    public int getColumnIndex(GSSignalTime time) {
        return this.getColumnIndex(time.getGametick());
    }

    public int getColumnIndex(long gametick) {
        return (int)gametick;
    }

    public int getMinimumWidth() {
        return this.getColumnX(this.minimumColumnCount);
    }

    public int getMinimumHeight() {
        return this.channelIndexToUUID.size() * (this.channelHeight + this.channelSpacing);
    }

    public GSSignalTime viewToModel(int x, int y) {
        int columnIndex = this.getColumnIndexFromX(x);
        if (columnIndex == -1) {
            return null;
        }
        int mt = 0;
        if (this.expandedColumnModel.isColumnExpanded(columnIndex)) {
            int columnX = this.getColumnX(columnIndex);
            if (x < columnX) {
                return null;
            }
            mt = (x - columnX) / 20;
        } else {
            int columnOffset;
            UUID channelUUID = this.getChannelUUIDFromView(y);
            int columnDuration = this.getColumnDuration(columnIndex);
            mt = channelUUID != null && this.isMultiCell(channelUUID, columnIndex) ? ((columnOffset = x - this.getColumnX(columnIndex)) > 20 ? columnDuration : (columnOffset < 10 ? 0 : columnDuration / 2)) : columnDuration / 2;
        }
        return this.getColumnTime(columnIndex, mt);
    }

    public int getColumnIndexFromX(int x) {
        if (x < 0) {
            return -1;
        }
        int columnIndex = x / 30;
        if (this.expandedColumnModel.hasExpandedColumn() && columnIndex >= this.expandedColumnModel.getMinColumnIndex()) {
            int maxIndex = this.expandedColumnModel.getMaxColumnIndex();
            int offset = x - this.getColumnX(columnIndex);
            for (columnIndex = this.expandedColumnModel.getMinColumnIndex(); columnIndex <= maxIndex; ++columnIndex) {
                if ((offset -= this.getColumnWidth(columnIndex)) >= 0) continue;
                return columnIndex;
            }
            return columnIndex + offset / 30;
        }
        return columnIndex;
    }

    public UUID getChannelUUIDFromView(int y) {
        if (y < 0) {
            return null;
        }
        int channelIndex = y / (this.channelHeight + this.channelSpacing);
        return this.channelIndexToUUID.get(channelIndex);
    }

    public GSSignalTime getDraggedTime(int x, int y) {
        if (this.expandedColumnModel.isSingleExpandedColumn()) {
            int minIndex = this.expandedColumnModel.getMinColumnIndex();
            int maxIndex = this.expandedColumnModel.getMaxColumnIndex();
            int columnIndex = GSMathUtil.clamp((int)this.getColumnIndexFromX(x), (int)minIndex, (int)maxIndex);
            int columnOffset = x - this.getColumnX(columnIndex);
            if (columnOffset < 0) {
                return null;
            }
            return this.getColumnTime(columnIndex, columnOffset / 20);
        }
        return this.viewToModel(x, y);
    }

    public long getColumnGametick(int columnIndex) {
        return columnIndex;
    }

    public GSSignalTime getColumnTime(int columnIndex, int mt) {
        return new GSSignalTime(this.getColumnGametick(columnIndex), mt);
    }

    public GSExpandedColumnModel getExpandedColumnModel() {
        return this.expandedColumnModel;
    }

    public int getChannelHeight() {
        return this.channelHeight;
    }

    public void setChannelHeight(int channelHeight) {
        if (channelHeight < 11) {
            channelHeight = 11;
        }
        if (channelHeight != this.channelHeight) {
            this.channelHeight = channelHeight;
            this.dispatchModelViewChangedEvent();
        }
    }

    public int getChannelSpacing() {
        return this.channelSpacing;
    }

    public void setChannelSpacing(int channelSpacing) {
        if (channelSpacing < 0) {
            channelSpacing = 0;
        }
        if (channelSpacing != this.channelSpacing) {
            this.channelSpacing = channelSpacing;
            this.dispatchModelViewChangedEvent();
        }
    }

    public void addModelViewListener(GSIModelViewListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listenters.add(listener);
    }

    public void removeModelViewListener(GSIModelViewListener listener) {
        this.listenters.remove(listener);
    }

    private void dispatchModelViewChangedEvent() {
        this.listenters.forEach(GSIModelViewListener::modelViewChanged);
    }

    @Override
    public void channelAdded(GSChannel channel, UUID prevUUID) {
        this.updateModelView();
    }

    @Override
    public void channelRemoved(GSChannel channel, UUID oldPrevUUID) {
        this.updateModelView();
    }

    @Override
    public void channelMoved(GSChannel channel, UUID newPrevUUID, UUID oldPrevUUID) {
        this.updateChannelIndexLookup();
        this.dispatchModelViewChangedEvent();
    }

    @Override
    public void entryAdded(GSChannelEntry entry) {
        this.updateModelView();
    }

    @Override
    public void entryRemoved(GSChannelEntry entry) {
        this.updateModelView();
    }

    @Override
    public void entryTimeChanged(GSChannelEntry entry, GSSignalTime oldStart, GSSignalTime oldEnd) {
        this.updateModelView();
    }

    @Override
    public void onExpandedColumnChanged(int minExpandedColumnIndex, int maxExpandedColumnIndex) {
        this.dispatchModelViewChangedEvent();
    }

    private class GSMultiCellIterator
    implements Iterator<GSMultiCellInfo> {
        private final Iterator<Map.Entry<Integer, Integer>> countEntryIterator;

        public GSMultiCellIterator(Iterator<Map.Entry<Integer, Integer>> countEntryIterator) {
            this.countEntryIterator = countEntryIterator;
        }

        @Override
        public boolean hasNext() {
            return this.countEntryIterator.hasNext();
        }

        @Override
        public GSMultiCellInfo next() {
            Map.Entry<Integer, Integer> info = this.countEntryIterator.next();
            int columnIndex = GSSequenceModelView.this.getColumnIndexFromLookup(info.getKey());
            int count = info.getValue();
            return new GSMultiCellInfo(columnIndex, count);
        }
    }
}

