/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.sequence;

import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.sequence.GSExpandedColumnModel;
import com.g4mesoft.captureplayback.panel.sequence.GSMultiCellInfo;
import com.g4mesoft.captureplayback.panel.sequence.GSSequenceModelView;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSEChannelEntryType;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.ui.panel.GSColoredIcon;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSIcon;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelUtil;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.panel.dropdown.GSDropdown;
import com.g4mesoft.ui.panel.dropdown.GSDropdownAction;
import com.g4mesoft.ui.panel.dropdown.GSDropdownItem;
import com.g4mesoft.ui.panel.dropdown.GSDropdownSubMenu;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.panel.scroll.GSIScrollable;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSColorUtil;
import com.g4mesoft.ui.util.GSTextUtil;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class GSSequencePanel
extends GSPanel
implements GSIScrollable,
GSISequenceListener,
GSIModelViewListener,
GSIMouseListener {
    private static final int TEXT_COLOR = -1;
    public static final int COLUMN_COLOR = -13750738;
    public static final int DARK_COLUMN_COLOR = -14013910;
    public static final int CHANNEL_SPACING_COLOR = -14671840;
    private static final int ENTRY_BORDER_THICKNESS = 2;
    private static final int MINIMUM_DRAG_DISTANCE = 5;
    private static final int DRAGGING_AREA_SIZE = 6;
    private static final int DRAGGING_PADDING = 2;
    private static final int DRAGGING_AREA_COLOR = 0x40FFFFFF;
    private static final int DOTTED_LINE_LENGTH = 4;
    private static final int DOTTED_LINE_SPACING = 3;
    private static final int DOTTED_LINE_COLOR = -12566464;
    private static final GSIcon TYPE_SELECTED_ICON = new GSColoredIcon(-1, 4, 4);
    private static final class_2561 CREATE_ENTRY_TEXT = GSTextUtil.translatable((String)"panel.sequencecontent.createentry");
    private static final class_2561 ENTRY_TYPE_TEXT = GSTextUtil.translatable((String)"panel.sequencecontent.entrytype");
    private static final class_2561 DELETE_ENTRY_TEXT = GSTextUtil.translatable((String)"panel.sequencecontent.deleteentry");
    private final GSSequence sequence;
    private final GSExpandedColumnModel expandedColumnModel;
    private final GSSequenceModelView modelView;
    private final GSRectangle tmpRenderRect;
    private int currentMouseX;
    private int currentMouseY;
    private UUID hoveredChannelUUID;
    private GSChannelEntry hoveredEntry;
    private int clickedMouseX;
    private int clickedMouseY;
    private GSSignalTime clickedMouseTime;
    private GSChannelEntry draggingEntry;
    private GSEDraggingType draggingType;
    private GSSignalTime draggingStartTime;
    private GSSignalTime draggingEndTime;
    private UUID draggedChannelUUID;
    private int draggedChannelY;
    private boolean editable;

    public GSSequencePanel(GSSequence sequence, GSSequenceModelView modelView) {
        this.sequence = sequence;
        this.expandedColumnModel = modelView.getExpandedColumnModel();
        this.modelView = modelView;
        this.tmpRenderRect = new GSRectangle();
        this.draggingType = GSEDraggingType.NOT_DRAGGING;
        this.addMouseEventListener(this);
        this.editable = true;
    }

    public void onShown() {
        super.onShown();
        this.sequence.addSequenceListener(this);
        this.modelView.addModelViewListener(this);
    }

    public void onHidden() {
        super.onHidden();
        this.sequence.removeSequenceListener(this);
        this.modelView.removeModelViewListener(this);
        this.stopDragging();
    }

    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        GSRectangle bounds = renderer.getClipBounds().intersection(0, 0, this.width, this.height);
        this.renderColumns(renderer, bounds);
        this.renderChannels(renderer, bounds);
        if (this.editable) {
            GSChannel draggedChannel = this.sequence.getChannel(this.draggedChannelUUID);
            if (draggedChannel != null) {
                this.renderDraggedChannel(renderer, draggedChannel, bounds);
            } else {
                this.renderHoveredEdge(renderer);
            }
        }
    }

    protected void renderColumns(GSIRenderer2D renderer, GSRectangle bounds) {
        this.renderColumns(renderer, bounds.y, bounds.height, bounds);
    }

    protected void renderColumns(GSIRenderer2D renderer, int y, int h, GSRectangle bounds) {
        if (y + h >= bounds.y && y - bounds.y < bounds.height) {
            int columnIndex = Math.max(0, this.modelView.getColumnIndexFromX(bounds.x));
            int cx = this.modelView.getColumnX(columnIndex);
            while (cx < bounds.x + bounds.width) {
                int cw = this.modelView.getColumnWidth(columnIndex);
                this.renderColumn(renderer, columnIndex, cx, y, cw, h);
                cx += cw;
                ++columnIndex;
            }
        }
    }

    protected void renderColumn(GSIRenderer2D renderer, int columnIndex, int cx, int y, int cw, int height) {
        renderer.fillRect(cx, y, cw, height, this.getColumnColor(columnIndex));
        renderer.drawVLine(cx + cw - 1, y, y + height, -14671840);
        if (this.expandedColumnModel.isColumnExpanded(columnIndex)) {
            int ly = y + 1 - y % 7;
            int duration = this.modelView.getColumnDuration(columnIndex);
            for (int mt = 1; mt < duration; ++mt) {
                int lx = this.modelView.getMicrotickColumnX(columnIndex, mt) - 1;
                renderer.drawDottedVLine(lx, ly, y + height, 4, 3, -12566464);
            }
        }
    }

    protected int getColumnColor(int columnIndex) {
        return (columnIndex & 1) != 0 ? -14013910 : -13750738;
    }

    protected void renderChannels(GSIRenderer2D renderer, GSRectangle bounds) {
        for (GSChannel channel : this.sequence.getChannels()) {
            int cy = this.modelView.getChannelY(channel.getChannelUUID());
            if (cy + this.modelView.getChannelHeight() < bounds.y || cy - bounds.y >= bounds.height) continue;
            if (channel.getChannelUUID().equals(this.draggedChannelUUID)) {
                int h = this.modelView.getChannelHeight() + this.modelView.getChannelSpacing();
                renderer.fillRect(bounds.x, cy, bounds.width, h, -13750738);
                continue;
            }
            this.renderChannel(renderer, channel, cy, bounds);
        }
    }

    protected void renderDraggedChannel(GSIRenderer2D renderer, GSChannel draggedChannel, GSRectangle bounds) {
        this.renderColumns(renderer, this.draggedChannelY, this.modelView.getChannelHeight(), bounds);
        this.renderChannel(renderer, draggedChannel, this.draggedChannelY, bounds);
    }

    protected void renderChannel(GSIRenderer2D renderer, GSChannel channel, int cy, GSRectangle bounds) {
        int ch = this.modelView.getChannelHeight();
        if (channel.getChannelUUID().equals(this.hoveredChannelUUID)) {
            renderer.fillRect(0, cy, this.width, ch, 0x30FFFFFF);
        }
        int entryOffsetY = cy - this.modelView.getChannelY(channel.getChannelUUID());
        for (GSChannelEntry entry : channel.getEntries()) {
            this.renderChannelEntry(renderer, entry, channel.getInfo().getColor(), entryOffsetY, bounds);
        }
        this.renderMultiCells(renderer, channel.getChannelUUID(), cy, bounds);
        renderer.fillRect(0, cy + ch, this.width, this.modelView.getChannelSpacing(), -14671840);
    }

    protected void renderChannelEntry(GSIRenderer2D renderer, GSChannelEntry entry, int color, int entryOffsetY, GSRectangle bounds) {
        GSRectangle rect = this.modelView.modelToView(entry, this.tmpRenderRect);
        if (rect != null) {
            rect.y += entryOffsetY;
            if (rect.intersects(bounds)) {
                if (this.draggingEntry == entry || this.hoveredEntry == entry) {
                    color = GSColorUtil.darker((int)color);
                }
                renderer.fillRect(rect.x, rect.y, rect.width, rect.height, GSColorUtil.darker((int)color));
                if (entry.getType().hasEndEvent()) {
                    rect.width -= 2;
                }
                if (entry.getType().hasStartEvent()) {
                    rect.x += 2;
                    rect.width -= 2;
                }
                rect.y += 2;
                rect.height -= 4;
                renderer.fillRect(rect.x, rect.y, rect.width, rect.height, color);
            }
        }
    }

    protected void renderMultiCells(GSIRenderer2D renderer, UUID channelUUID, int cy, GSRectangle bounds) {
        Iterator<GSMultiCellInfo> itr = this.modelView.getMultiCellIterator(channelUUID);
        while (itr.hasNext()) {
            GSMultiCellInfo multiCellInfo = itr.next();
            if (this.expandedColumnModel.isColumnExpanded(multiCellInfo.getColumnIndex())) continue;
            this.renderMultiCell(renderer, cy, multiCellInfo, bounds);
        }
    }

    protected void renderMultiCell(GSIRenderer2D renderer, int cy, GSMultiCellInfo multiCellInfo, GSRectangle bounds) {
        int columnIndex = multiCellInfo.getColumnIndex();
        int cw = this.modelView.getColumnWidth(columnIndex);
        int cx = this.modelView.getColumnX(columnIndex);
        if (cx + cw >= bounds.x && cx - bounds.x < bounds.width) {
            String infoText = this.formatMultiCellInfo(multiCellInfo);
            int ty = cy + (this.modelView.getChannelHeight() - renderer.getTextAscent()) / 2;
            renderer.drawCenteredText(infoText, cx + cw / 2, ty, -1);
        }
    }

    protected String formatMultiCellInfo(GSMultiCellInfo multiCellInfo) {
        if (multiCellInfo.getCount() > 9) {
            return "+";
        }
        return Integer.toString(multiCellInfo.getCount());
    }

    protected void renderHoveredEdge(GSIRenderer2D renderer) {
        switch (this.draggingType.ordinal()) {
            case 0: {
                int mouseY;
                int mouseX;
                GSEResizeArea resizeArea;
                if (this.hoveredEntry == null || (resizeArea = this.getHoveredResizeArea(this.hoveredEntry, mouseX = renderer.getMouseX(), mouseY = renderer.getMouseY())) == null) break;
                this.renderResizeArea(renderer, this.hoveredEntry, resizeArea);
                break;
            }
            case 2: {
                this.renderResizeArea(renderer, this.draggingEntry, GSEResizeArea.HOVERING_START);
                break;
            }
            case 3: {
                this.renderResizeArea(renderer, this.draggingEntry, GSEResizeArea.HOVERING_END);
                break;
            }
        }
    }

    private void renderResizeArea(GSIRenderer2D renderer, GSChannelEntry entry, GSEResizeArea resizeArea) {
        GSRectangle rect = this.modelView.modelToView(entry, this.tmpRenderRect);
        if (rect != null) {
            rect.x = resizeArea == GSEResizeArea.HOVERING_END ? (rect.x += rect.width - 6) : (rect.x -= 2);
            rect.y -= 2;
            rect.width = 8;
            rect.height += 4;
            renderer.fillRect(rect.x, rect.y, rect.width, rect.height, 0x40FFFFFF);
        }
    }

    public void populateRightClickMenu(GSDropdown dropdown, int x, int y) {
        UUID channelUUID = this.hoveredChannelUUID;
        GSChannelEntry entry = this.hoveredEntry;
        dropdown.addItem((GSDropdownItem)new GSDropdownAction(CREATE_ENTRY_TEXT, () -> {
            GSSignalTime time = this.modelView.viewToModel(x, y);
            GSChannel channel = this.sequence.getChannel(channelUUID);
            if (time != null && channel != null) {
                channel.tryAddEntry(time, time.offsetCopy(1L, 0));
            }
        }));
        dropdown.separate();
        GSDropdown entryTypeMenu = new GSDropdown();
        if (entry != null) {
            for (GSEChannelEntryType type : GSEChannelEntryType.TYPES) {
                GSIcon icon = entry.getType() == type ? TYPE_SELECTED_ICON : null;
                class_5250 text = GSTextUtil.translatable((String)type.getName());
                entryTypeMenu.addItem((GSDropdownItem)new GSDropdownAction(icon, (class_2561)text, () -> entry.setType(type)));
            }
        }
        GSDropdownSubMenu entryType = new GSDropdownSubMenu(ENTRY_TYPE_TEXT, entryTypeMenu);
        dropdown.addItem((GSDropdownItem)entryType);
        GSDropdownAction deleteEntry = new GSDropdownAction(DELETE_ENTRY_TEXT, () -> this.removeEntry(channelUUID, entry));
        dropdown.addItem((GSDropdownItem)deleteEntry);
        entryType.setEnabled(entry != null);
        deleteEntry.setEnabled(entry != null);
    }

    protected GSDimension calculatePreferredSize() {
        return new GSDimension(this.modelView.getMinimumWidth(), this.modelView.getMinimumHeight());
    }

    public boolean isScrollableWidthFilled() {
        return true;
    }

    public boolean isScrollableHeightFilled() {
        return true;
    }

    public float getIncrementalScrollX(int sign) {
        int scrollX = GSPanelUtil.getScrollX((GSPanel)this);
        int leadingColumnIndex = this.modelView.getColumnIndexFromX(scrollX);
        int alignedColumn = leadingColumnIndex + sign;
        if (leadingColumnIndex != -1 && alignedColumn >= 0) {
            return sign * (this.modelView.getColumnX(alignedColumn) - scrollX);
        }
        return super.getIncrementalScrollX(sign);
    }

    public float getIncrementalScrollY(int sign) {
        int scrollY = GSPanelUtil.getScrollY((GSPanel)this);
        UUID leadingChannelUUID = this.modelView.getChannelUUIDFromView(scrollY);
        if (leadingChannelUUID != null) {
            int delta = 2 * (this.modelView.getChannelHeight() + this.modelView.getChannelSpacing());
            return delta + sign * (this.modelView.getChannelY(leadingChannelUUID) - scrollY);
        }
        return super.getIncrementalScrollY(sign);
    }

    public void mouseMoved(GSMouseEvent event) {
        this.currentMouseX = event.getX();
        this.currentMouseY = event.getY();
        this.updateHoveredEntry();
    }

    private void updateHoveredEntry() {
        this.hoveredEntry = this.hoveredChannelUUID != null ? this.getEntryAt(this.hoveredChannelUUID, this.currentMouseX, this.currentMouseY) : null;
    }

    private GSChannelEntry getEntryAt(UUID channelUUID, int x, int y) {
        GSRectangle rect;
        int columnIndex;
        boolean precise;
        GSChannelEntry entry;
        GSChannel hoveredChannel = this.sequence.getChannel(channelUUID);
        GSSignalTime hoveredTime = this.modelView.viewToModel(x, y);
        if (hoveredChannel != null && hoveredTime != null && (entry = hoveredChannel.getEntryAt(hoveredTime, precise = this.shouldUsePreciseHovering(channelUUID, columnIndex = this.modelView.getColumnIndex(hoveredTime)))) != null && (rect = this.modelView.modelToView(entry)) != null && rect.contains(x, y)) {
            return entry;
        }
        return null;
    }

    private boolean shouldUsePreciseHovering(UUID channelUUID, int columnIndex) {
        if (this.expandedColumnModel.isColumnExpanded(columnIndex)) {
            return true;
        }
        return this.modelView.isMultiCell(channelUUID, columnIndex);
    }

    public void mousePressed(GSMouseEvent event) {
        if (event.getButton() == 0) {
            this.clickedMouseX = event.getX();
            this.clickedMouseY = event.getY();
            this.clickedMouseTime = this.modelView.viewToModel(event.getX(), event.getY());
            if (!event.isConsumed() && this.editable && this.hoveredEntry != null) {
                if (event.isModifierHeld(2)) {
                    if (this.draggingType == GSEDraggingType.NOT_DRAGGING) {
                        this.removeEntry(this.hoveredChannelUUID, this.hoveredEntry);
                        event.consume();
                    }
                } else {
                    GSEResizeArea resizeArea = this.getHoveredResizeArea(this.hoveredEntry, event.getX(), event.getY());
                    if (this.startDragging(this.hoveredEntry, this.resizeAreaToDraggingType(resizeArea))) {
                        event.consume();
                    }
                }
            }
        }
    }

    private boolean startDragging(GSChannelEntry entry, GSEDraggingType type) {
        if (this.isDraggingAllowed(entry, type)) {
            this.draggingEntry = entry;
            this.draggingType = type;
            this.draggingStartTime = entry.getStartTime();
            this.draggingEndTime = entry.getEndTime();
            return true;
        }
        return false;
    }

    private void stopDragging() {
        if (this.draggingType != GSEDraggingType.NOT_DRAGGING) {
            this.draggingEntry = null;
            this.draggingType = GSEDraggingType.NOT_DRAGGING;
            this.draggingStartTime = null;
            this.draggingEndTime = null;
        }
    }

    private boolean isDraggingAllowed(GSChannelEntry entry, GSEDraggingType type) {
        int endColumn;
        if (type != GSEDraggingType.DRAGGING || !this.expandedColumnModel.hasExpandedColumn()) {
            return true;
        }
        int startColumn = this.modelView.getColumnIndex(entry.getStartTime());
        if (startColumn == (endColumn = this.modelView.getColumnIndex(entry.getEndTime()))) {
            return true;
        }
        if (this.expandedColumnModel.isColumnExpanded(startColumn)) {
            return false;
        }
        return !this.expandedColumnModel.isColumnExpanded(endColumn);
    }

    private GSEDraggingType resizeAreaToDraggingType(GSEResizeArea resizeArea) {
        if (resizeArea == GSEResizeArea.HOVERING_START) {
            return GSEDraggingType.RESIZING_START;
        }
        if (resizeArea == GSEResizeArea.HOVERING_END) {
            return GSEDraggingType.RESIZING_END;
        }
        return GSEDraggingType.DRAGGING;
    }

    private void removeEntry(UUID channelUUID, GSChannelEntry entry) {
        GSChannel channel = this.sequence.getChannel(channelUUID);
        if (channel == entry.getParent()) {
            channel.removeEntry(entry.getEntryUUID());
        }
    }

    private GSEResizeArea getHoveredResizeArea(GSChannelEntry entry, int mouseX, int mouseY) {
        GSRectangle r = this.modelView.modelToView(entry);
        if (r == null || !r.contains(mouseX, mouseY)) {
            return null;
        }
        if (mouseX < r.x + 6) {
            if (this.isColumnModifiable(this.modelView.getColumnIndex(entry.getStartTime()))) {
                return GSEResizeArea.HOVERING_START;
            }
        } else if (mouseX >= r.x + r.width - 6 && this.isColumnModifiable(this.modelView.getColumnIndex(entry.getEndTime()))) {
            return GSEResizeArea.HOVERING_END;
        }
        return null;
    }

    public void mouseReleased(GSMouseEvent event) {
        if (!event.isConsumed() && event.getButton() == 0) {
            GSEResizeArea resizeArea;
            if (this.draggingType != GSEDraggingType.NOT_DRAGGING) {
                this.stopDragging();
                event.consume();
            }
            if (this.currentMouseX == this.clickedMouseX && this.currentMouseY == this.clickedMouseY && this.hoveredEntry != null && (resizeArea = this.getHoveredResizeArea(this.hoveredEntry, event.getX(), event.getY())) != null) {
                this.toggleEntryEdge(this.hoveredEntry, resizeArea);
                event.consume();
            }
        }
    }

    private void toggleEntryEdge(GSChannelEntry entry, GSEResizeArea resizeArea) {
        if (resizeArea == GSEResizeArea.HOVERING_START) {
            entry.setType(entry.getType().toggleStart());
        } else {
            entry.setType(entry.getType().toggleEnd());
        }
    }

    public void mouseDragged(GSMouseEvent event) {
        if (!event.isConsumed() && this.editable && event.getButton() == 0) {
            int dy;
            int dx;
            if (this.draggingEntry != null) {
                if (this.dragSelectedEntry(event.getX(), event.getY())) {
                    event.consume();
                }
            } else if (this.hoveredChannelUUID != null && this.hoveredEntry == null && (dx = event.getX() - this.clickedMouseX) * dx + (dy = event.getY() - this.clickedMouseY) * dy > 25) {
                GSEDraggingType draggingType;
                GSEDraggingType gSEDraggingType = draggingType = dx > 0 ? GSEDraggingType.RESIZING_END : GSEDraggingType.RESIZING_START;
                if (this.addChannelEntry(draggingType, event.getX(), event.getY())) {
                    event.consume();
                }
            }
        }
    }

    private boolean dragSelectedEntry(int mouseX, int mouseY) {
        GSSignalTime draggedTime = this.modelView.getDraggedTime(mouseX, mouseY);
        if (draggedTime != null) {
            switch (this.draggingType.ordinal()) {
                case 1: {
                    return this.moveDraggedEntry(draggedTime);
                }
                case 2: {
                    return this.changeDraggedStart(draggedTime);
                }
                case 3: {
                    return this.changeDraggedEnd(draggedTime);
                }
            }
        }
        return false;
    }

    private boolean moveDraggedEntry(GSSignalTime mouseTime) {
        long dgt = 0L;
        int dmt = 0;
        if (this.expandedColumnModel.hasExpandedColumn()) {
            dmt = mouseTime.getMicrotick() - this.clickedMouseTime.getMicrotick();
        } else {
            dgt = mouseTime.getGametick() - this.clickedMouseTime.getGametick();
        }
        if (this.draggingStartTime.getGametick() + dgt < 0L || this.draggingStartTime.getMicrotick() + dmt < 0) {
            return false;
        }
        if (this.draggingEndTime.getGametick() + dgt < 0L || this.draggingEndTime.getMicrotick() + dmt < 0) {
            return false;
        }
        GSSignalTime startTime = this.draggingStartTime.offsetCopy(dgt, dmt);
        GSSignalTime endTime = this.draggingEndTime.offsetCopy(dgt, dmt);
        return this.moveEntry(this.draggingEntry, startTime, endTime);
    }

    private boolean isValidDraggedTime(GSSignalTime currentTime, GSSignalTime mouseTime) {
        int c0 = this.modelView.getColumnIndex(currentTime);
        int c1 = this.modelView.getColumnIndex(mouseTime);
        return this.isColumnModifiable(c1) && this.isColumnModifiable(c0);
    }

    private boolean changeDraggedStart(GSSignalTime mouseTime) {
        if (this.isValidDraggedTime(this.draggingEntry.getStartTime(), mouseTime)) {
            GSSignalTime startTime = this.offsetDraggedTime(this.draggingEntry.getStartTime(), mouseTime);
            return this.moveEntry(this.draggingEntry, startTime, this.draggingEntry.getEndTime());
        }
        return false;
    }

    private boolean changeDraggedEnd(GSSignalTime mouseTime) {
        if (this.isValidDraggedTime(this.draggingEntry.getEndTime(), mouseTime)) {
            GSSignalTime endTime = this.offsetDraggedTime(this.draggingEntry.getEndTime(), mouseTime);
            return this.moveEntry(this.draggingEntry, this.draggingEntry.getStartTime(), endTime);
        }
        return false;
    }

    private GSSignalTime offsetDraggedTime(GSSignalTime t0, GSSignalTime t1) {
        return this.expandedColumnModel.hasExpandedColumn() ? t1 : new GSSignalTime(t1.getGametick(), t0.getMicrotick());
    }

    private boolean moveEntry(GSChannelEntry entry, GSSignalTime startTime, GSSignalTime endTime) {
        if (!this.canMoveEntry(startTime, endTime, this.draggingEntry)) {
            return false;
        }
        this.draggingEntry.setTimespan(startTime, endTime);
        return true;
    }

    private boolean canMoveEntry(GSSignalTime startTime, GSSignalTime endTime, GSChannelEntry entry) {
        if (entry.getStartTime().isEqual(startTime) && entry.getEndTime().isEqual(endTime)) {
            return false;
        }
        if (startTime.getGametick() < this.modelView.getColumnGametick(0)) {
            return false;
        }
        if (startTime.getMicrotick() < 0) {
            return false;
        }
        if (endTime.isBefore(startTime)) {
            return false;
        }
        GSChannel channel = entry.getParent();
        return !channel.isOverlappingEntries(startTime, endTime, entry);
    }

    private boolean addChannelEntry(GSEDraggingType draggingType, int mouseX, int mouseY) {
        GSChannel hoveredChannel = this.sequence.getChannel(this.hoveredChannelUUID);
        if (hoveredChannel != null) {
            GSSignalTime t0 = this.modelView.getDraggedTime(this.clickedMouseX, this.clickedMouseY);
            GSSignalTime t1 = this.modelView.getDraggedTime(mouseX, mouseY);
            if (t0 != null && t1 != null) {
                GSChannelEntry entry;
                if (t0.isAfter(t1)) {
                    GSSignalTime tmp = t0;
                    t0 = t1;
                    t1 = tmp;
                }
                if (this.expandedColumnModel.hasExpandedColumn()) {
                    int c1;
                    int c0 = this.modelView.getColumnIndex(t0);
                    if (c0 != (c1 = this.modelView.getColumnIndex(t1)) || !this.isColumnModifiable(c0)) {
                        return false;
                    }
                } else {
                    t0 = new GSSignalTime(t0.getGametick(), 0);
                    t1 = new GSSignalTime(t1.getGametick(), 0);
                }
                if ((entry = hoveredChannel.tryAddEntry(t0, t1)) != null) {
                    this.hoveredEntry = entry;
                    return this.startDragging(entry, draggingType);
                }
            }
        }
        return false;
    }

    private boolean isColumnModifiable(int columnIndex) {
        if (this.expandedColumnModel.hasExpandedColumn()) {
            return this.expandedColumnModel.isColumnExpanded(columnIndex);
        }
        return true;
    }

    @Override
    public void channelRemoved(GSChannel channel, UUID oldPrevUUID) {
        GSChannel draggingChannel;
        UUID channelUUID = channel.getChannelUUID();
        if (this.draggingEntry != null && channelUUID.equals((draggingChannel = this.draggingEntry.getParent()).getChannelUUID())) {
            this.stopDragging();
        }
    }

    @Override
    public void entryRemoved(GSChannelEntry entry) {
        UUID entryUUID = entry.getEntryUUID();
        if (this.hoveredEntry != null && entryUUID.equals(this.hoveredEntry.getEntryUUID())) {
            this.hoveredEntry = null;
        }
        if (this.draggingEntry != null && entryUUID.equals(this.draggingEntry.getEntryUUID())) {
            this.stopDragging();
        }
    }

    @Override
    public void modelViewChanged() {
        this.updateHoveredEntry();
    }

    public UUID getHoveredChannelUUID() {
        return this.hoveredChannelUUID;
    }

    public void setHoveredCell(int columnIndex, UUID channelUUID) {
        this.hoveredChannelUUID = channelUUID;
        this.updateHoveredEntry();
    }

    public UUID getDraggedChannelUUID() {
        return this.draggedChannelUUID;
    }

    public void setDraggedChannelUUID(UUID draggedChannelUUID) {
        this.draggedChannelUUID = draggedChannelUUID;
    }

    public int getDraggedChannelY() {
        return this.draggedChannelY;
    }

    public void setDraggedChannelY(int draggedChannelY) {
        this.draggedChannelY = draggedChannelY;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (!editable) {
            this.draggingType = GSEDraggingType.NOT_DRAGGING;
        }
    }

    private static enum GSEDraggingType {
        NOT_DRAGGING,
        DRAGGING,
        RESIZING_START,
        RESIZING_END;

    }

    private static enum GSEResizeArea {
        HOVERING_START,
        HOVERING_END;

    }
}

