/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSChannelMovedDelta
extends GSChannelDelta {
    private UUID newPrevUUID;
    private UUID oldPrevUUID;

    public GSChannelMovedDelta() {
    }

    public GSChannelMovedDelta(UUID channelUUID, UUID newPrevUUID, UUID oldPrevUUID) {
        super(channelUUID);
        this.newPrevUUID = newPrevUUID;
        this.oldPrevUUID = oldPrevUUID;
    }

    private void moveChannel(UUID newPrevUUID, UUID oldPrevUUID, GSSequence sequence) throws GSDeltaException {
        this.checkPreviousChannel(this.getChannel(sequence), oldPrevUUID);
        sequence.moveChannelAfter(this.channelUUID, newPrevUUID);
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        this.moveChannel(this.oldPrevUUID, this.newPrevUUID, sequence);
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.moveChannel(this.newPrevUUID, this.oldPrevUUID, sequence);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newPrevUUID = buf.readBoolean() ? buf.readUUID() : null;
        this.oldPrevUUID = buf.readBoolean() ? buf.readUUID() : null;
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeBoolean(this.newPrevUUID != null);
        if (this.newPrevUUID != null) {
            buf.writeUUID(this.newPrevUUID);
        }
        buf.writeBoolean(this.oldPrevUUID != null);
        if (this.oldPrevUUID != null) {
            buf.writeUUID(this.oldPrevUUID);
        }
    }
}

