/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSDeltaRegistries;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.session.GSIUndoRedoEntry;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;

public class GSSequenceUndoRedoEntry
implements GSIUndoRedoEntry {
    private GSIDelta<GSSequence> delta;
    private long timestampMillis;

    GSSequenceUndoRedoEntry() {
    }

    public GSSequenceUndoRedoEntry(GSIDelta<GSSequence> delta) {
        this(delta, System.currentTimeMillis());
    }

    public GSSequenceUndoRedoEntry(GSIDelta<GSSequence> delta, long timestampMillis) {
        this.delta = delta;
        this.timestampMillis = timestampMillis;
    }

    private GSSequence getSequence(GSSession session) throws GSDeltaException {
        GSSequence sequence = session.get(GSSession.SEQUENCE);
        if (sequence == null) {
            throw new GSDeltaException("Session does not contain a sequence");
        }
        return sequence;
    }

    @Override
    public void undo(GSSession session) throws GSDeltaException {
        this.delta.unapply(this.getSequence(session));
    }

    @Override
    public void redo(GSSession session) throws GSDeltaException {
        this.delta.apply(this.getSequence(session));
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        this.delta = GSDeltaRegistries.SEQUENCE_DELTA_REGISTRY.read(buf);
        this.timestampMillis = buf.readLong();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        GSDeltaRegistries.SEQUENCE_DELTA_REGISTRY.write(buf, this.delta);
        buf.writeLong(this.timestampMillis);
    }

    @Override
    public long getTimestampMillis() {
        return this.timestampMillis;
    }
}

