/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.captureplayback.session.GSESessionRequestType;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3222;

public class GSSessionRequestPacket
implements GSIPacket {
    private GSESessionRequestType requestType;
    private UUID assetUUID;

    public GSSessionRequestPacket() {
    }

    public GSSessionRequestPacket(GSESessionRequestType requestType, UUID structureUUID) {
        this.requestType = requestType;
        this.assetUUID = structureUUID;
    }

    public void read(GSDecodeBuffer buf) throws IOException {
        this.requestType = GSESessionRequestType.fromIndex(buf.readInt());
        if (this.requestType == null) {
            throw new IOException("Unknown request type");
        }
        this.assetUUID = buf.readUUID();
    }

    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeInt(this.requestType.getIndex());
        buf.writeUUID(this.assetUUID);
    }

    public void handleOnServer(GSServerController controller, class_3222 player) {
        GSCapturePlaybackServerModule module = (GSCapturePlaybackServerModule)controller.getModule(GSCapturePlaybackServerModule.class);
        if (module != null) {
            module.onSessionRequest(player, this.requestType, this.assetUUID);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
    }
}

