/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.stream.frame;

import com.g4mesoft.captureplayback.stream.GSSignalEvent;
import com.g4mesoft.captureplayback.stream.frame.GSISignalFrame;
import java.util.List;
import java.util.NoSuchElementException;

public class GSBasicSignalFrame
implements GSISignalFrame {
    private final List<GSSignalEvent> events;
    private int position;
    private int markedPosition;

    public GSBasicSignalFrame(List<GSSignalEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException("events is null!");
        }
        this.events = events;
        this.position = 0;
        this.markedPosition = -1;
    }

    @Override
    public GSSignalEvent peek() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.events.get(this.position);
    }

    @Override
    public GSSignalEvent next() throws NoSuchElementException {
        GSSignalEvent event = this.peek();
        ++this.position;
        return event;
    }

    @Override
    public int remaining() {
        return this.events.size() - this.position;
    }

    @Override
    public boolean hasNext() {
        return this.remaining() > 0;
    }

    @Override
    public void mark() {
        this.markedPosition = this.position;
    }

    @Override
    public void reset() {
        if (this.markedPosition == -1) {
            throw new IllegalStateException("No mark has been set!");
        }
        this.position = this.markedPosition;
        this.invalidateMark();
    }

    @Override
    public void invalidateMark() {
        this.markedPosition = -1;
    }
}

