/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.stream.frame;

import com.g4mesoft.captureplayback.stream.GSSignalEvent;
import com.g4mesoft.captureplayback.stream.frame.GSISignalFrame;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class GSMergedSignalFrame
implements GSISignalFrame {
    private final LinkedList<GSISignalFrame> frames = new LinkedList();

    public void merge(GSISignalFrame frame) {
        if (frame != EMPTY) {
            this.frames.addLast(frame);
        }
    }

    @Override
    public GSSignalEvent peek() throws NoSuchElementException {
        return this.getNextFrame().peek();
    }

    @Override
    public GSSignalEvent next() throws NoSuchElementException {
        return this.getNextFrame().next();
    }

    private GSISignalFrame getNextFrame() throws NoSuchElementException {
        GSISignalFrame nextFrame = null;
        GSSignalEvent nextEvent = null;
        for (GSISignalFrame frame : this.frames) {
            if (!frame.hasNext()) continue;
            GSSignalEvent event = frame.peek();
            if (nextEvent != null && nextEvent.compareTo(event) <= 0) continue;
            nextFrame = frame;
            nextEvent = event;
        }
        if (nextFrame == null) {
            throw new NoSuchElementException();
        }
        return nextFrame;
    }

    @Override
    public int remaining() {
        int remaining = 0;
        for (GSISignalFrame frame : this.frames) {
            remaining += frame.remaining();
        }
        return remaining;
    }

    @Override
    public boolean hasNext() {
        return this.remaining() > 0;
    }

    @Override
    public void mark() {
        for (GSISignalFrame frame : this.frames) {
            frame.mark();
        }
    }

    @Override
    public void reset() {
        for (GSISignalFrame frame : this.frames) {
            frame.reset();
        }
    }

    @Override
    public void invalidateMark() {
        for (GSISignalFrame frame : this.frames) {
            frame.invalidateMark();
        }
    }
}

