/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class GSMutableLinkedHashMap<K, V>
implements Map<K, V> {
    private final Map<K, GSNode<K, V>> nodes;
    private GSNode<K, V> first;
    private GSNode<K, V> last;
    private GSKeySet keySet;
    private GSValues values;
    private GSEntrySet entrySet;

    public GSMutableLinkedHashMap() {
        this.nodes = new HashMap<K, GSNode<K, V>>();
        this.last = null;
        this.first = null;
    }

    public GSMutableLinkedHashMap(int initialCapacity) {
        this.nodes = new HashMap<K, GSNode<K, V>>(initialCapacity);
        this.last = null;
        this.first = null;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nodes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        GSNode<K, V> node = this.first;
        while (node != null) {
            if (value.equals(node.value)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        GSNode<K, V> node = this.nodes.get(key);
        return node == null ? null : (V)node.value;
    }

    public V getFirst() {
        return this.first == null ? null : (V)this.first.value;
    }

    public Map.Entry<K, V> getFirstEntry() {
        return this.first;
    }

    public V getLast() {
        return this.last == null ? null : (V)this.last.value;
    }

    public Map.Entry<K, V> getLastEntry() {
        return this.last;
    }

    public V getPrevious(K key) {
        Map.Entry<K, V> entry = this.getPreviousEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }

    public Map.Entry<K, V> getPreviousEntry(K key) {
        GSNode<K, V> node = this.nodes.get(key);
        if (node == null) {
            return this.last;
        }
        return node.prev == null ? null : node.prev;
    }

    public V getNext(K key) {
        Map.Entry<K, V> entry = this.getNextEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }

    public Map.Entry<K, V> getNextEntry(K key) {
        GSNode<K, V> node = this.nodes.get(key);
        if (node == null) {
            return this.first;
        }
        return node.next == null ? null : node.next;
    }

    @Override
    public V put(K key, V value) {
        return this.putLast(key, value);
    }

    public V putFirst(K key, V value) {
        GSNode<K, V> node = new GSNode<K, V>(key, value);
        GSNode<K, V> prev = this.nodes.put(key, node);
        if (prev != null) {
            this.removeNode(prev);
        }
        this.insertNodeFirst(node);
        return prev == null ? null : (V)prev.value;
    }

    private void insertNodeFirst(GSNode<K, V> node) {
        if (this.first == null) {
            this.last = node;
            this.first = this.last;
        } else {
            this.first.prev = node;
            node.next = this.first;
            this.first = node;
        }
    }

    public V putLast(K key, V value) {
        GSNode<K, V> node = new GSNode<K, V>(key, value);
        GSNode<K, V> prev = this.nodes.put(key, node);
        if (prev != null) {
            this.removeNode(prev);
        }
        this.insertNodeLast(node);
        return prev == null ? null : (V)prev.value;
    }

    private void insertNodeLast(GSNode<K, V> node) {
        if (this.last == null) {
            this.last = node;
            this.first = this.last;
        } else {
            this.last.next = node;
            node.prev = this.last;
            this.last = node;
        }
    }

    @Override
    public V remove(Object key) {
        GSNode<K, V> node = this.nodes.remove(key);
        if (node != null) {
            this.removeNode(node);
            return node.value;
        }
        return null;
    }

    private void removeNode(GSNode<K, V> node) {
        GSNode prev = node.prev;
        GSNode next = node.next;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            node.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            node.next = null;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.nodes.clear();
        GSNode<K, V> node = this.first;
        while (node != null) {
            GSNode tmpNext = node.next;
            node.prev = null;
            node.next = null;
            node = tmpNext;
        }
        this.last = null;
        this.first = null;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new GSKeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new GSValues();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new GSEntrySet();
        }
        return this.entrySet;
    }

    public Map.Entry<K, V> moveAfter(K key, K otherKey) {
        GSNode<K, V> srcNode = this.nodes.get(key);
        GSNode<K, V> dstNode = this.nodes.get(otherKey);
        if (srcNode == null) {
            throw new NoSuchElementException();
        }
        if (srcNode == dstNode) {
            throw new IllegalArgumentException("key and otherKey are the same");
        }
        this.removeNode(srcNode);
        if (dstNode != null) {
            srcNode.next = dstNode.next;
            srcNode.prev = dstNode;
            dstNode.next = srcNode;
            if (srcNode.next == null) {
                this.last = srcNode;
            } else {
                srcNode.next.prev = srcNode;
            }
        } else {
            this.insertNodeFirst(srcNode);
        }
        return srcNode;
    }

    public Map.Entry<K, V> moveBefore(K key, K otherKey) {
        GSNode<K, V> srcNode = this.nodes.get(key);
        GSNode<K, V> dstNode = this.nodes.get(otherKey);
        if (srcNode == null) {
            throw new NoSuchElementException();
        }
        if (srcNode == dstNode) {
            throw new IllegalArgumentException("key and otherKey are the same");
        }
        this.removeNode(srcNode);
        if (dstNode != null) {
            srcNode.prev = dstNode.prev;
            srcNode.next = dstNode;
            dstNode.prev = srcNode;
            if (srcNode.prev == null) {
                this.first = srcNode;
            } else {
                srcNode.prev.next = srcNode;
            }
        } else {
            this.insertNodeLast(srcNode);
        }
        return srcNode;
    }

    private static class GSNode<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;
        private GSNode<K, V> prev;
        private GSNode<K, V> next;

        public GSNode(K key, V value) {
            this.key = key;
            this.value = value;
            this.next = null;
            this.prev = null;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public boolean equals(Object other) {
            Map.Entry e;
            if (other == this) {
                return true;
            }
            return other instanceof Map.Entry && Objects.equals(this.key, (e = (Map.Entry)other).getKey()) && Objects.equals(this.value, e.getValue());
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + String.valueOf(this.value);
        }
    }

    final class GSKeySet
    extends AbstractSet<K> {
        GSKeySet() {
        }

        @Override
        public int size() {
            return GSMutableLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            GSMutableLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new GSKeyIterator(GSMutableLinkedHashMap.this);
        }

        @Override
        public boolean contains(Object obj) {
            return GSMutableLinkedHashMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return GSMutableLinkedHashMap.this.remove(obj) != null;
        }

        @Override
        public void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException("action is null");
            }
            GSNode node = GSMutableLinkedHashMap.this.first;
            while (node != null) {
                action.accept(node.key);
                node = node.next;
            }
        }
    }

    final class GSValues
    extends AbstractCollection<V> {
        GSValues() {
        }

        @Override
        public int size() {
            return GSMutableLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            GSMutableLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new GSValueIterator(GSMutableLinkedHashMap.this);
        }

        @Override
        public boolean contains(Object o) {
            return GSMutableLinkedHashMap.this.containsValue(o);
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException("action is null");
            }
            GSNode node = GSMutableLinkedHashMap.this.first;
            while (node != null) {
                action.accept(node.value);
                node = node.next;
            }
        }
    }

    final class GSEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        GSEntrySet() {
        }

        @Override
        public int size() {
            return GSMutableLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            GSMutableLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new GSEntryIterator(GSMutableLinkedHashMap.this);
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            GSNode node = GSMutableLinkedHashMap.this.nodes.get(entry.getKey());
            return node != null && node.equals(entry);
        }

        @Override
        public boolean remove(Object obj) {
            if (obj instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                GSNode node = GSMutableLinkedHashMap.this.nodes.get(key);
                if (node != null && Objects.equals(value, node.value)) {
                    GSMutableLinkedHashMap.this.remove(key);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException("action is null");
            }
            GSNode node = GSMutableLinkedHashMap.this.first;
            while (node != null) {
                action.accept(node);
                node = node.next;
            }
        }
    }

    final class GSEntryIterator
    extends GSMapIterator<Map.Entry<K, V>> {
        GSEntryIterator(GSMutableLinkedHashMap this$0) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class GSKeyIterator
    extends GSMapIterator<K> {
        GSKeyIterator(GSMutableLinkedHashMap this$0) {
        }

        @Override
        public K next() {
            return this.nextNode().key;
        }
    }

    final class GSValueIterator
    extends GSMapIterator<V> {
        GSValueIterator(GSMutableLinkedHashMap this$0) {
        }

        @Override
        public V next() {
            return this.nextNode().value;
        }
    }

    abstract class GSMapIterator<E>
    implements Iterator<E> {
        private GSNode<K, V> prev = null;
        private GSNode<K, V> next;

        public GSMapIterator() {
            this.next = GSMutableLinkedHashMap.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public GSNode<K, V> nextNode() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.next;
            this.next = this.next.next;
            return this.prev;
        }

        @Override
        public void remove() {
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            GSMutableLinkedHashMap.this.remove(this.prev.key);
            this.prev = null;
        }
    }
}

