/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSEAssetNamespace;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.function.Predicate;

public class GSAssetHandle
implements Comparable<GSAssetHandle> {
    private static final int HANDLE_MAX_LENGTH = 20;
    private static final int BASE36_COUNT = 36;
    private static final int BASE36_POW_6 = -2118184960;
    private static final long BASE36_POW_12 = 4486707524770201600L;
    private static final char[] BASE36_ALPHABET;
    private static final Random secureRandom;
    public static final char NAMESPACE_SEPARATOR = ':';
    private final GSEAssetNamespace namespace;
    private final String handle;
    private String identifierCache;

    public GSAssetHandle(GSEAssetNamespace namespace, String handle) {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is null!");
        }
        if (handle.isEmpty()) {
            throw new IllegalArgumentException("Handle is empty!");
        }
        if (handle.length() > 20) {
            throw new IllegalArgumentException("Handle length exceeds maximum!");
        }
        if (!GSAssetHandle.isBase36OrUnderscore(handle)) {
            throw new IllegalArgumentException("Handle contains non-base36/underscore characters!");
        }
        this.namespace = namespace;
        this.handle = handle;
        this.identifierCache = null;
    }

    private static boolean isBase36OrUnderscore(String handle) {
        for (int i = 0; i < handle.length(); ++i) {
            if (GSAssetHandle.isBase36OrUnderscore(handle.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isBase36OrUnderscore(char c) {
        return GSAssetHandle.isBase36(c) || c == '_';
    }

    private static boolean isBase36(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        return 'a' <= c && c <= 'z';
    }

    public static GSAssetHandle randomBase36(GSEAssetNamespace namespace, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be positive!");
        }
        if (length > 20) {
            throw new IllegalArgumentException("length must be at most 20");
        }
        char[] result = new char[length];
        int i = 0;
        while (i < length) {
            long value = secureRandom.nextLong(4486707524770201600L);
            for (int j = 0; j < 12 && i < length; ++j) {
                result[i++] = BASE36_ALPHABET[(int)(value % 36L)];
                value /= 36L;
            }
        }
        return new GSAssetHandle(namespace, new String(result));
    }

    public static GSAssetHandle randomBase36Unique(GSEAssetNamespace namespace, int length, Predicate<GSAssetHandle> existsPred) {
        GSAssetHandle result;
        while (existsPred.test(result = GSAssetHandle.randomBase36(namespace, length))) {
        }
        return result;
    }

    public static final GSAssetHandle fromName(GSEAssetNamespace namespace, String name, String suffix) {
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < name.length() && sb.length() < 20 - suffix.length(); ++i) {
            char c = Character.toLowerCase(name.charAt(i));
            if (GSAssetHandle.isBase36(c)) {
                sb.append(c);
                continue;
            }
            if (sb.isEmpty() || sb.charAt(sb.length() - 1) == '_') continue;
            sb.append('_');
        }
        if (sb.isEmpty()) {
            sb.append('_');
        }
        sb.append(suffix);
        return new GSAssetHandle(namespace, sb.toString());
    }

    public static GSAssetHandle fromNameUnique(GSEAssetNamespace namespace, String name, Predicate<GSAssetHandle> existsPred) {
        GSAssetHandle result;
        int i = 1;
        do {
            String suffix = i > 1 || name.isEmpty() ? Integer.toString(i) : "";
            result = GSAssetHandle.fromName(namespace, name, suffix);
            if (++i >= 0) continue;
            throw new IllegalStateException("Unable to create unique handle");
        } while (existsPred.test(result));
        return result;
    }

    public static GSAssetHandle fromString(String identifier) {
        if (identifier.length() < 2 || identifier.charAt(1) != ':') {
            throw new IllegalArgumentException("Identifier does not specify a namespace!");
        }
        GSEAssetNamespace namespace = GSEAssetNamespace.fromIdentifier(identifier.charAt(0));
        if (namespace == null) {
            throw new IllegalArgumentException("Unknown namespace '" + identifier.charAt(0) + "'.");
        }
        return new GSAssetHandle(namespace, identifier.substring(2));
    }

    public GSEAssetNamespace getNamespace() {
        return this.namespace;
    }

    public String getHandle() {
        return this.handle;
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + this.namespace.hashCode();
        hash = 31 * hash + this.handle.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GSAssetHandle) {
            GSAssetHandle other = (GSAssetHandle)obj;
            if (this.namespace != other.namespace) {
                return false;
            }
            return this.handle.equals(other.handle);
        }
        return false;
    }

    @Override
    public int compareTo(GSAssetHandle other) {
        if (this.namespace != other.namespace) {
            return this.namespace.getIndex() < other.namespace.getIndex() ? -1 : 1;
        }
        return this.handle.compareTo(other.handle);
    }

    public String toString() {
        if (this.identifierCache == null) {
            StringBuilder sb = new StringBuilder(2 + this.handle.length());
            sb.append(this.namespace.getIdentifier());
            sb.append(':');
            sb.append(this.handle);
            this.identifierCache = sb.toString();
        }
        return this.identifierCache;
    }

    public static GSAssetHandle read(GSDecodeBuffer buf) throws IOException {
        GSEAssetNamespace namespace = GSEAssetNamespace.fromIndex(buf.readUnsignedByte());
        if (namespace == null) {
            throw new IllegalArgumentException("Unknown namespace");
        }
        String handle = buf.readString(20);
        return new GSAssetHandle(namespace, handle);
    }

    public static void write(GSEncodeBuffer buf, GSAssetHandle handle) throws IOException {
        buf.writeUnsignedByte((short)handle.namespace.getIndex());
        buf.writeString(handle.handle);
    }

    static {
        int c;
        secureRandom = new SecureRandom();
        BASE36_ALPHABET = new char[36];
        int i = 0;
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            GSAssetHandle.BASE36_ALPHABET[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            GSAssetHandle.BASE36_ALPHABET[i++] = c;
        }
    }
}

